package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface ReplicaSetSpecFluent<A extends ReplicaSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg0);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.SelectorNested<A> withNewSelector();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.SelectorNested<A> editSelector();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<io.fabric8.kubernetes.api.model.apps.ReplicaSetSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
