package io.fabric8.kubernetes.api.model.networking.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IngressBackendFluent<A extends IngressBackendFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public TypedLocalObjectReference getResource();
    public A withResource(TypedLocalObjectReference resource);
    public Boolean hasResource();
    public A withNewResource(String apiGroup,String kind,String name);
    
/**
 * This method has been deprecated, please use method buildService instead.
 * @return The buildable object.
 */
@Deprecated public IngressServiceBackend getService();
    public IngressServiceBackend buildService();
    public A withService(IngressServiceBackend service);
    public Boolean hasService();
    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> withNewService();
    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> withNewServiceLike(IngressServiceBackend item);
    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> editService();
    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> editOrNewService();
    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item);
    public interface ServiceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressServiceBackendFluent<io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<N>> {

            public N and();
            public N endService();    }


}
