package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NetworkPolicyIngressRuleFluent<A extends NetworkPolicyIngressRuleFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToFrom(int index,NetworkPolicyPeer item);
    public A setToFrom(int index,NetworkPolicyPeer item);
    public A addToFrom(NetworkPolicyPeer... items);
    public A addAllToFrom(Collection<NetworkPolicyPeer> items);
    public A removeFromFrom(NetworkPolicyPeer... items);
    public A removeAllFromFrom(Collection<NetworkPolicyPeer> items);
    public A removeMatchingFromFrom(Predicate<NetworkPolicyPeerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public List<NetworkPolicyPeer> getFrom();
    public List<NetworkPolicyPeer> buildFrom();
    public NetworkPolicyPeer buildFrom(int index);
    public NetworkPolicyPeer buildFirstFrom();
    public NetworkPolicyPeer buildLastFrom();
    public NetworkPolicyPeer buildMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate);
    public Boolean hasMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate);
    public A withFrom(List<NetworkPolicyPeer> from);
    public A withFrom(NetworkPolicyPeer... from);
    public Boolean hasFrom();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> addNewFrom();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> addNewFromLike(NetworkPolicyPeer item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> setNewFromLike(int index,NetworkPolicyPeer item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> editFrom(int index);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> editFirstFrom();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> editLastFrom();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<A> editMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate);
    public A addToPorts(int index,NetworkPolicyPort item);
    public A setToPorts(int index,NetworkPolicyPort item);
    public A addToPorts(NetworkPolicyPort... items);
    public A addAllToPorts(Collection<NetworkPolicyPort> items);
    public A removeFromPorts(NetworkPolicyPort... items);
    public A removeAllFromPorts(Collection<NetworkPolicyPort> items);
    public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<NetworkPolicyPort> getPorts();
    public List<NetworkPolicyPort> buildPorts();
    public NetworkPolicyPort buildPort(int index);
    public NetworkPolicyPort buildFirstPort();
    public NetworkPolicyPort buildLastPort();
    public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate);
    public Boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate);
    public A withPorts(List<NetworkPolicyPort> ports);
    public A withPorts(NetworkPolicyPort... ports);
    public Boolean hasPorts();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> addNewPort();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> addNewPortLike(NetworkPolicyPort item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> setNewPortLike(int index,NetworkPolicyPort item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> editPort(int index);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> editFirstPort();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> editLastPort();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate);
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyPeerFluent<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.FromNested<N>> {

            public N and();
            public N endFrom();    }


    public interface PortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyPortFluent<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent.PortsNested<N>> {

            public N and();
            public N endPort();    }


}
