package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressTLSBuilder extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluentImpl<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent;
    Boolean validationEnabled;

    public IngressTLSBuilder() {
        this(true);
    }

    public IngressTLSBuilder(Boolean validationEnabled) {
        this(new IngressTLS(), validationEnabled);
    }

    public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressTLS(), validationEnabled);
    }

    public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance) {
        this(fluent, instance, true);
    }

    public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHosts(instance.getHosts()); 
        fluent.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance) {
        this(instance,true);
    }

    public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHosts(instance.getHosts()); 
        this.withSecretName(instance.getSecretName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS build() {
        IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressTLSBuilder that = (IngressTLSBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
