package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressClassSpecBuilder extends IngressClassSpecFluentImpl<IngressClassSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IngressClassSpec,IngressClassSpecBuilder> {

    IngressClassSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IngressClassSpecBuilder() {
        this(true);
    }

    public IngressClassSpecBuilder(Boolean validationEnabled) {
        this(new IngressClassSpec(), validationEnabled);
    }

    public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressClassSpec(), validationEnabled);
    }

    public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent,IngressClassSpec instance) {
        this(fluent, instance, true);
    }

    public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent,IngressClassSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withController(instance.getController()); 
        fluent.withParameters(instance.getParameters()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressClassSpecBuilder(IngressClassSpec instance) {
        this(instance,true);
    }

    public IngressClassSpecBuilder(IngressClassSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withController(instance.getController()); 
        this.withParameters(instance.getParameters()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressClassSpec build() {
        IngressClassSpec buildable = new IngressClassSpec(fluent.getController(),fluent.getParameters());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressClassSpecBuilder that = (IngressClassSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
