package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface NetworkPolicySpecFluent<A extends NetworkPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToEgress(int index,NetworkPolicyEgressRule item);
    public A setToEgress(int index,NetworkPolicyEgressRule item);
    public A addToEgress(NetworkPolicyEgressRule... items);
    public A addAllToEgress(Collection<NetworkPolicyEgressRule> items);
    public A removeFromEgress(NetworkPolicyEgressRule... items);
    public A removeAllFromEgress(Collection<NetworkPolicyEgressRule> items);
    public A removeMatchingFromEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<NetworkPolicyEgressRule> getEgress();
    public List<NetworkPolicyEgressRule> buildEgress();
    public NetworkPolicyEgressRule buildEgress(int index);
    public NetworkPolicyEgressRule buildFirstEgress();
    public NetworkPolicyEgressRule buildLastEgress();
    public NetworkPolicyEgressRule buildMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
    public Boolean hasMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
    public A withEgress(List<NetworkPolicyEgressRule> egress);
    public A withEgress(NetworkPolicyEgressRule... egress);
    public Boolean hasEgress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> addNewEgress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(NetworkPolicyEgressRule item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index,NetworkPolicyEgressRule item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> editEgress(int index);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> editFirstEgress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> editLastEgress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<NetworkPolicyEgressRuleBuilder> predicate);
    public A addToIngress(int index,NetworkPolicyIngressRule item);
    public A setToIngress(int index,NetworkPolicyIngressRule item);
    public A addToIngress(NetworkPolicyIngressRule... items);
    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items);
    public A removeFromIngress(NetworkPolicyIngressRule... items);
    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items);
    public A removeMatchingFromIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<NetworkPolicyIngressRule> getIngress();
    public List<NetworkPolicyIngressRule> buildIngress();
    public NetworkPolicyIngressRule buildIngress(int index);
    public NetworkPolicyIngressRule buildFirstIngress();
    public NetworkPolicyIngressRule buildLastIngress();
    public NetworkPolicyIngressRule buildMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
    public Boolean hasMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
    public A withIngress(List<NetworkPolicyIngressRule> ingress);
    public A withIngress(NetworkPolicyIngressRule... ingress);
    public Boolean hasIngress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> addNewIngress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index,NetworkPolicyIngressRule item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> editIngress(int index);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> editFirstIngress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> editLastIngress();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<NetworkPolicyIngressRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPodSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getPodSelector();
    public LabelSelector buildPodSelector();
    public A withPodSelector(LabelSelector podSelector);
    public Boolean hasPodSelector();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item);
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector();
    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item);
    public A addToPolicyTypes(int index,String item);
    public A setToPolicyTypes(int index,String item);
    public A addToPolicyTypes(String... items);
    public A addAllToPolicyTypes(Collection<String> items);
    public A removeFromPolicyTypes(String... items);
    public A removeAllFromPolicyTypes(Collection<String> items);
    public List<String> getPolicyTypes();
    public String getPolicyType(int index);
    public String getFirstPolicyType();
    public String getLastPolicyType();
    public String getMatchingPolicyType(Predicate<String> predicate);
    public Boolean hasMatchingPolicyType(Predicate<String> predicate);
    public A withPolicyTypes(List<String> policyTypes);
    public A withPolicyTypes(String... policyTypes);
    public Boolean hasPolicyTypes();
    public A addNewPolicyType(StringBuilder arg1);
    public A addNewPolicyType(int[] arg1,int arg2,int arg3);
    public A addNewPolicyType(char[] arg1);
    public A addNewPolicyType(StringBuffer arg1);
    public A addNewPolicyType(byte[] arg1,int arg2);
    public A addNewPolicyType(byte[] arg1);
    public A addNewPolicyType(char[] arg1,int arg2,int arg3);
    public A addNewPolicyType(byte[] arg1,int arg2,int arg3);
    public A addNewPolicyType(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewPolicyType(String arg1);
    public interface EgressNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyEgressRuleFluent<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.EgressNested<N>> {

            public N and();
            public N endEgress();    }


    public interface IngressNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyIngressRuleFluent<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.IngressNested<N>> {

            public N and();
            public N endIngress();    }


    public interface PodSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicySpecFluent.PodSelectorNested<N>> {

            public N and();
            public N endPodSelector();    }


}
