package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceBackendPortBuilder extends ServiceBackendPortFluentImpl<ServiceBackendPortBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<ServiceBackendPort,ServiceBackendPortBuilder> {

    ServiceBackendPortFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBackendPortBuilder() {
        this(true);
    }

    public ServiceBackendPortBuilder(Boolean validationEnabled) {
        this(new ServiceBackendPort(), validationEnabled);
    }

    public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent) {
        this(fluent, true);
    }

    public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ServiceBackendPort(), validationEnabled);
    }

    public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent,ServiceBackendPort instance) {
        this(fluent, instance, true);
    }

    public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent,ServiceBackendPort instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNumber(instance.getNumber()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceBackendPortBuilder(ServiceBackendPort instance) {
        this(instance,true);
    }

    public ServiceBackendPortBuilder(ServiceBackendPort instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNumber(instance.getNumber()); 
        this.validationEnabled = validationEnabled; 
    }

    public ServiceBackendPort build() {
        ServiceBackendPort buildable = new ServiceBackendPort(fluent.getName(),fluent.getNumber());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceBackendPortBuilder that = (ServiceBackendPortBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
