package io.fabric8.kubernetes.api.model.policy;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SELinuxStrategyOptionsFluentImpl<A extends SELinuxStrategyOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SELinuxStrategyOptionsFluent<A> {

    private String rule;
    private SELinuxOptions seLinuxOptions;

    public SELinuxStrategyOptionsFluentImpl() {
    }

    public SELinuxStrategyOptionsFluentImpl(SELinuxStrategyOptions instance) {
        this.withRule(instance.getRule()); 
        this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
    }

    public String getRule() {
        return this.rule;
    }

    public A withRule(String rule) {
        this.rule=rule; return (A) this;
    }

    public Boolean hasRule() {
        return this.rule != null;
    }

    public A withNewRule(StringBuilder arg1) {
        return (A)withRule(new String(arg1));
    }

    public A withNewRule(int[] arg1,int arg2,int arg3) {
        return (A)withRule(new String(arg1, arg2, arg3));
    }

    public A withNewRule(char[] arg1) {
        return (A)withRule(new String(arg1));
    }

    public A withNewRule(StringBuffer arg1) {
        return (A)withRule(new String(arg1));
    }

    public A withNewRule(byte[] arg1,int arg2) {
        return (A)withRule(new String(arg1, arg2));
    }

    public A withNewRule(byte[] arg1) {
        return (A)withRule(new String(arg1));
    }

    public A withNewRule(char[] arg1,int arg2,int arg3) {
        return (A)withRule(new String(arg1, arg2, arg3));
    }

    public A withNewRule(byte[] arg1,int arg2,int arg3) {
        return (A)withRule(new String(arg1, arg2, arg3));
    }

    public A withNewRule(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRule(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRule(String arg1) {
        return (A)withRule(new String(arg1));
    }

    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions=seLinuxOptions; return (A) this;
    }

    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public A withNewSeLinuxOptions(String level,String role,String type,String user) {
        return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SELinuxStrategyOptionsFluentImpl that = (SELinuxStrategyOptionsFluentImpl) o;
        if (rule != null ? !rule.equals(that.rule) :that.rule != null) return false;
        if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(rule,  seLinuxOptions,  super.hashCode());
    }

}
