package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ContainerFluent<T extends ContainerFluent<T>> extends Fluent<T>{


    public T addToArgs( String ...items);    public T removeFromArgs( String ...items);    public List<String> getArgs();    public T withArgs( List<String> args);    public T withArgs( String ...args);    public T addToCommand( String ...items);    public T removeFromCommand( String ...items);    public List<String> getCommand();    public T withCommand( List<String> command);    public T withCommand( String ...command);    public T addToEnv( EnvVar ...items);    public T removeFromEnv( EnvVar ...items);    public List<EnvVar> getEnv();    public T withEnv( List<EnvVar> env);    public T withEnv( EnvVar ...env);    public EnvNested<T> addNewEnv();    public EnvNested<T> addNewEnvLike( EnvVar item);    public String getImage();    public T withImage( String image);    public String getImagePullPolicy();    public T withImagePullPolicy( String imagePullPolicy);    public Lifecycle getLifecycle();    public T withLifecycle( Lifecycle lifecycle);    public LifecycleNested<T> withNewLifecycle();    public LifecycleNested<T> withNewLifecycleLike( Lifecycle item);    public LifecycleNested<T> editLifecycle();    public Probe getLivenessProbe();    public T withLivenessProbe( Probe livenessProbe);    public LivenessProbeNested<T> withNewLivenessProbe();    public LivenessProbeNested<T> withNewLivenessProbeLike( Probe item);    public LivenessProbeNested<T> editLivenessProbe();    public String getName();    public T withName( String name);    public T addToPorts( ContainerPort ...items);    public T removeFromPorts( ContainerPort ...items);    public List<ContainerPort> getPorts();    public T withPorts( List<ContainerPort> ports);    public T withPorts( ContainerPort ...ports);    public PortsNested<T> addNewPort();    public PortsNested<T> addNewPortLike( ContainerPort item);    public T addNewPort( Integer containerPort,  String hostIP,  Integer hostPort,  String name,  String protocol);    public Probe getReadinessProbe();    public T withReadinessProbe( Probe readinessProbe);    public ReadinessProbeNested<T> withNewReadinessProbe();    public ReadinessProbeNested<T> withNewReadinessProbeLike( Probe item);    public ReadinessProbeNested<T> editReadinessProbe();    public ResourceRequirements getResources();    public T withResources( ResourceRequirements resources);    public ResourcesNested<T> withNewResources();    public ResourcesNested<T> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<T> editResources();    public SecurityContext getSecurityContext();    public T withSecurityContext( SecurityContext securityContext);    public SecurityContextNested<T> withNewSecurityContext();    public SecurityContextNested<T> withNewSecurityContextLike( SecurityContext item);    public SecurityContextNested<T> editSecurityContext();    public Boolean isStdin();    public T withStdin( Boolean stdin);    public Boolean isStdinOnce();    public T withStdinOnce( Boolean stdinOnce);    public String getTerminationMessagePath();    public T withTerminationMessagePath( String terminationMessagePath);    public Boolean isTty();    public T withTty( Boolean tty);    public T addToVolumeMounts( VolumeMount ...items);    public T removeFromVolumeMounts( VolumeMount ...items);    public List<VolumeMount> getVolumeMounts();    public T withVolumeMounts( List<VolumeMount> volumeMounts);    public T withVolumeMounts( VolumeMount ...volumeMounts);    public VolumeMountsNested<T> addNewVolumeMount();    public VolumeMountsNested<T> addNewVolumeMountLike( VolumeMount item);    public T addNewVolumeMount( String mountPath,  String name,  Boolean readOnly);    public String getWorkingDir();    public T withWorkingDir( String workingDir);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface EnvNested<N> extends Nested<N>, EnvVarFluent<EnvNested<N>>{
            public N endEnv();            public N and();        
}

    public interface LifecycleNested<N> extends Nested<N>, LifecycleFluent<LifecycleNested<N>>{
            public N endLifecycle();            public N and();        
}

    public interface LivenessProbeNested<N> extends Nested<N>, ProbeFluent<LivenessProbeNested<N>>{
            public N endLivenessProbe();            public N and();        
}

    public interface PortsNested<N> extends Nested<N>, ContainerPortFluent<PortsNested<N>>{
            public N endPort();            public N and();        
}

    public interface ReadinessProbeNested<N> extends Nested<N>, ProbeFluent<ReadinessProbeNested<N>>{
            public N endReadinessProbe();            public N and();        
}

    public interface ResourcesNested<N> extends Nested<N>, ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface SecurityContextNested<N> extends Nested<N>, SecurityContextFluent<SecurityContextNested<N>>{
            public N and();            public N endSecurityContext();        
}

    public interface VolumeMountsNested<N> extends Nested<N>, VolumeMountFluent<VolumeMountsNested<N>>{
            public N and();            public N endVolumeMount();        
}


}
