package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NamedClusterFluentImpl<T extends NamedClusterFluent<T>> extends BaseFluent<T> implements NamedClusterFluent<T>{

     VisitableBuilder<Cluster, ?> cluster;     String name;     Map<String, Object> additionalProperties = new HashMap();
public NamedClusterFluentImpl(){
    
}
public NamedClusterFluentImpl( NamedCluster instance ){
    this.withCluster(instance.getCluster()); this.withName(instance.getName()); 
}

    public Cluster getCluster(){
    return this.cluster!=null?this.cluster.build():null;
    }
    public T withCluster( Cluster cluster){
    if (cluster!=null){ this.cluster= new ClusterBuilder(cluster); _visitables.add(this.cluster);} return (T) this;
    }
    public ClusterNested<T> withNewCluster(){
    return new ClusterNestedImpl<T>();
    }
    public ClusterNested<T> withNewClusterLike( Cluster item){
    return new ClusterNestedImpl<T>(item);
    }
    public ClusterNested<T> editCluster(){
    return withNewClusterLike(getCluster());
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterFluentImpl that = (NamedClusterFluentImpl) o;
if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ClusterNestedImpl<N> extends ClusterFluentImpl<ClusterNested<N>> implements ClusterNested<N>{

        private final ClusterBuilder builder;
    
             ClusterNestedImpl ( Cluster item){
        this.builder = new ClusterBuilder(this, item);
        }
             ClusterNestedImpl (){
        this.builder = new ClusterBuilder(this);
        }
    
            public N endCluster(){
            return and();
        }
            public N and(){
            return (N) NamedClusterFluentImpl.this.withCluster(builder.build());
        }
    
}


}
