package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NodeFluent<T extends NodeFluent<T>> extends Fluent<T>{


    public Node.ApiVersion getApiVersion();    public T withApiVersion( Node.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public NodeSpec getSpec();    public T withSpec( NodeSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( NodeSpec item);    public SpecNested<T> editSpec();    public T withNewSpec( String externalID,  String podCIDR,  String providerID,  Boolean unschedulable);    public NodeStatus getStatus();    public T withStatus( NodeStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( NodeStatus item);    public StatusNested<T> editStatus();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, NodeSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, NodeStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
