package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface HorizontalPodAutoscalerSpecFluent<T extends HorizontalPodAutoscalerSpecFluent<T>> extends Fluent<T>{


    public CPUTargetUtilization getCpuUtilization();    public T withCpuUtilization( CPUTargetUtilization cpuUtilization);    public CpuUtilizationNested<T> withNewCpuUtilization();    public CpuUtilizationNested<T> withNewCpuUtilizationLike( CPUTargetUtilization item);    public CpuUtilizationNested<T> editCpuUtilization();    public T withNewCpuUtilization( Integer targetPercentage);    public Integer getMaxReplicas();    public T withMaxReplicas( Integer maxReplicas);    public Integer getMinReplicas();    public T withMinReplicas( Integer minReplicas);    public SubresourceReference getScaleRef();    public T withScaleRef( SubresourceReference scaleRef);    public ScaleRefNested<T> withNewScaleRef();    public ScaleRefNested<T> withNewScaleRefLike( SubresourceReference item);    public ScaleRefNested<T> editScaleRef();    public T withNewScaleRef( String apiVersion,  String kind,  String name,  String subresource);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface CpuUtilizationNested<N> extends Nested<N>, CPUTargetUtilizationFluent<CpuUtilizationNested<N>>{
            public N and();            public N endCpuUtilization();        
}

    public interface ScaleRefNested<N> extends Nested<N>, SubresourceReferenceFluent<ScaleRefNested<N>>{
            public N endScaleRef();            public N and();        
}


}
