package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class BuildSpecBuilder extends BuildSpecFluentImpl<BuildSpecBuilder> implements VisitableBuilder<BuildSpec,BuildSpecBuilder>{

     BuildSpecFluent<?> fluent;
public BuildSpecBuilder(){
    this(new BuildSpec());
}
public BuildSpecBuilder( BuildSpecFluent<?> fluent ){
    this(fluent, new BuildSpec());
}
public BuildSpecBuilder( BuildSpecFluent<?> fluent , BuildSpec instance ){
    this.fluent = fluent; fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); fluent.withOutput(instance.getOutput()); fluent.withResources(instance.getResources()); fluent.withRevision(instance.getRevision()); fluent.withServiceAccount(instance.getServiceAccount()); fluent.withSource(instance.getSource()); fluent.withStrategy(instance.getStrategy()); 
}
public BuildSpecBuilder( BuildSpec instance ){
    this.fluent = this; this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); this.withOutput(instance.getOutput()); this.withResources(instance.getResources()); this.withRevision(instance.getRevision()); this.withServiceAccount(instance.getServiceAccount()); this.withSource(instance.getSource()); this.withStrategy(instance.getStrategy()); 
}

public EditableBuildSpec build(){
    EditableBuildSpec buildable = new EditableBuildSpec(fluent.getCompletionDeadlineSeconds(),fluent.getOutput(),fluent.getResources(),fluent.getRevision(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildSpecBuilder that = (BuildSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
