package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface EndpointSubsetFluent<T extends EndpointSubsetFluent<T>> extends Fluent<T>{


    public T addToAddresses( EndpointAddress ...items);    public T removeFromAddresses( EndpointAddress ...items);    public List<EndpointAddress> getAddresses();    public T withAddresses( List<EndpointAddress> addresses);    public T withAddresses( EndpointAddress ...addresses);    public AddressesNested<T> addNewAddresse();    public AddressesNested<T> addNewAddresseLike( EndpointAddress item);    public T addToNotReadyAddresses( EndpointAddress ...items);    public T removeFromNotReadyAddresses( EndpointAddress ...items);    public List<EndpointAddress> getNotReadyAddresses();    public T withNotReadyAddresses( List<EndpointAddress> notReadyAddresses);    public T withNotReadyAddresses( EndpointAddress ...notReadyAddresses);    public NotReadyAddressesNested<T> addNewNotReadyAddresse();    public NotReadyAddressesNested<T> addNewNotReadyAddresseLike( EndpointAddress item);    public T addToPorts( EndpointPort ...items);    public T removeFromPorts( EndpointPort ...items);    public List<EndpointPort> getPorts();    public T withPorts( List<EndpointPort> ports);    public T withPorts( EndpointPort ...ports);    public PortsNested<T> addNewPort();    public PortsNested<T> addNewPortLike( EndpointPort item);    public T addNewPort( String name,  Integer port,  String protocol);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AddressesNested<N> extends Nested<N>, EndpointAddressFluent<AddressesNested<N>>{
            public N and();            public N endAddresse();        
}

    public interface NotReadyAddressesNested<N> extends Nested<N>, EndpointAddressFluent<NotReadyAddressesNested<N>>{
            public N endNotReadyAddresse();            public N and();        
}

    public interface PortsNested<N> extends Nested<N>, EndpointPortFluent<PortsNested<N>>{
            public N endPort();            public N and();        
}


}
