package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DaemonSetStatusFluentImpl<T extends DaemonSetStatusFluent<T>> extends BaseFluent<T> implements DaemonSetStatusFluent<T>{

     Integer currentNumberScheduled;     Integer desiredNumberScheduled;     Integer numberMisscheduled;     Map<String, Object> additionalProperties = new HashMap();
public DaemonSetStatusFluentImpl(){
    
}
public DaemonSetStatusFluentImpl( DaemonSetStatus instance ){
    this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
}

    public Integer getCurrentNumberScheduled(){
    return this.currentNumberScheduled;
    }
    public T withCurrentNumberScheduled( Integer currentNumberScheduled){
    this.currentNumberScheduled=currentNumberScheduled; return (T) this;
    }
    public Integer getDesiredNumberScheduled(){
    return this.desiredNumberScheduled;
    }
    public T withDesiredNumberScheduled( Integer desiredNumberScheduled){
    this.desiredNumberScheduled=desiredNumberScheduled; return (T) this;
    }
    public Integer getNumberMisscheduled(){
    return this.numberMisscheduled;
    }
    public T withNumberMisscheduled( Integer numberMisscheduled){
    this.numberMisscheduled=numberMisscheduled; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DaemonSetStatusFluentImpl that = (DaemonSetStatusFluentImpl) o;
if (currentNumberScheduled != null ? !currentNumberScheduled.equals(that.currentNumberScheduled) :that.currentNumberScheduled != null) return false;
if (desiredNumberScheduled != null ? !desiredNumberScheduled.equals(that.desiredNumberScheduled) :that.desiredNumberScheduled != null) return false;
if (numberMisscheduled != null ? !numberMisscheduled.equals(that.numberMisscheduled) :that.numberMisscheduled != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
