package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public class JobSpecFluentImpl<T extends JobSpecFluent<T>> extends BaseFluent<T> implements JobSpecFluent<T>{

     Integer completions;     Integer parallelism;     VisitableBuilder<PodSelector, ?> selector;     VisitableBuilder<PodTemplateSpec, ?> template;     Map<String, Object> additionalProperties = new HashMap();
public JobSpecFluentImpl(){
    
}
public JobSpecFluentImpl( JobSpec instance ){
    this.withCompletions(instance.getCompletions()); this.withParallelism(instance.getParallelism()); this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); 
}

    public Integer getCompletions(){
    return this.completions;
    }
    public T withCompletions( Integer completions){
    this.completions=completions; return (T) this;
    }
    public Integer getParallelism(){
    return this.parallelism;
    }
    public T withParallelism( Integer parallelism){
    this.parallelism=parallelism; return (T) this;
    }
    public PodSelector getSelector(){
    return this.selector!=null?this.selector.build():null;
    }
    public T withSelector( PodSelector selector){
    if (selector!=null){ this.selector= new PodSelectorBuilder(selector); _visitables.add(this.selector);} return (T) this;
    }
    public SelectorNested<T> withNewSelector(){
    return new SelectorNestedImpl<T>();
    }
    public SelectorNested<T> withNewSelectorLike( PodSelector item){
    return new SelectorNestedImpl<T>(item);
    }
    public SelectorNested<T> editSelector(){
    return withNewSelectorLike(getSelector());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public T withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (T) this;
    }
    public TemplateNested<T> withNewTemplate(){
    return new TemplateNestedImpl<T>();
    }
    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl<T>(item);
    }
    public TemplateNested<T> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
JobSpecFluentImpl that = (JobSpecFluentImpl) o;
if (completions != null ? !completions.equals(that.completions) :that.completions != null) return false;
if (parallelism != null ? !parallelism.equals(that.parallelism) :that.parallelism != null) return false;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SelectorNestedImpl<N> extends PodSelectorFluentImpl<SelectorNested<N>> implements SelectorNested<N>{

        private final PodSelectorBuilder builder;
    
             SelectorNestedImpl (){
        this.builder = new PodSelectorBuilder(this);
        }
             SelectorNestedImpl ( PodSelector item){
        this.builder = new PodSelectorBuilder(this, item);
        }
    
            public N endSelector(){
            return and();
        }
            public N and(){
            return (N) JobSpecFluentImpl.this.withSelector(builder.build());
        }
    
}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) JobSpecFluentImpl.this.withTemplate(builder.build());
        }
    
}


}
