
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "dockerImageRepository",
    "tags"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ImageStreamSpec {

    /**
     * optional field if specified this stream is backed by a Docker repository on this server
     * 
     */
    @JsonProperty("dockerImageRepository")
    private String dockerImageRepository;
    /**
     * map arbitrary string values to specific image locators
     * 
     */
    @JsonProperty("tags")
    @Valid
    private List<NamedTagReference> tags = new ArrayList<NamedTagReference>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImageStreamSpec() {
    }

    /**
     * 
     * @param dockerImageRepository
     * @param tags
     */
    public ImageStreamSpec(String dockerImageRepository, List<NamedTagReference> tags) {
        this.dockerImageRepository = dockerImageRepository;
        this.tags = tags;
    }

    /**
     * optional field if specified this stream is backed by a Docker repository on this server
     * 
     * @return
     *     The dockerImageRepository
     */
    @JsonProperty("dockerImageRepository")
    public String getDockerImageRepository() {
        return dockerImageRepository;
    }

    /**
     * optional field if specified this stream is backed by a Docker repository on this server
     * 
     * @param dockerImageRepository
     *     The dockerImageRepository
     */
    @JsonProperty("dockerImageRepository")
    public void setDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
    }

    /**
     * map arbitrary string values to specific image locators
     * 
     * @return
     *     The tags
     */
    @JsonProperty("tags")
    public List<NamedTagReference> getTags() {
        return tags;
    }

    /**
     * map arbitrary string values to specific image locators
     * 
     * @param tags
     *     The tags
     */
    @JsonProperty("tags")
    public void setTags(List<NamedTagReference> tags) {
        this.tags = tags;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
