package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface PolicyFluent<T extends PolicyFluent<T>> extends Fluent<T>{


    public Policy.ApiVersion getApiVersion();    public T withApiVersion( Policy.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public String getLastModified();    public T withLastModified( String lastModified);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToRoles( NamedRole ...items);    public T removeFromRoles( NamedRole ...items);    public List<NamedRole> getRoles();    public T withRoles( List<NamedRole> roles);    public T withRoles( NamedRole ...roles);    public RolesNested<T> addNewRole();    public RolesNested<T> addNewRoleLike( NamedRole item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface RolesNested<N> extends Nested<N>, NamedRoleFluent<RolesNested<N>>{
            public N endRole();            public N and();        
}


}
