/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.JobCondition;
import io.fabric8.kubernetes.api.model.JobConditionBuilder;
import io.fabric8.kubernetes.api.model.JobConditionFluentImpl;
import io.fabric8.kubernetes.api.model.JobStatus;
import io.fabric8.kubernetes.api.model.JobStatusFluent;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobStatusFluentImpl<A extends JobStatusFluent<A>>
extends BaseFluent<A>
implements JobStatusFluent<A> {
    private Integer active;
    private TimeBuilder completionTime;
    private List<JobConditionBuilder> conditions = new ArrayList<JobConditionBuilder>();
    private Integer failed;
    private TimeBuilder startTime;
    private Integer succeeded;

    public JobStatusFluentImpl() {
    }

    public JobStatusFluentImpl(JobStatus instance) {
        this.withActive(instance.getActive());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null;
    }

    @Override
    @Deprecated
    public Time getCompletionTime() {
        return this.completionTime != null ? this.completionTime.build() : null;
    }

    @Override
    public Time buildCompletionTime() {
        return this.completionTime != null ? this.completionTime.build() : null;
    }

    @Override
    public A withCompletionTime(Time completionTime) {
        this._visitables.remove(this.completionTime);
        if (completionTime != null) {
            this.completionTime = new TimeBuilder(completionTime);
            this._visitables.add(this.completionTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public JobStatusFluent.CompletionTimeNested<A> withNewCompletionTime() {
        return new CompletionTimeNestedImpl();
    }

    @Override
    public JobStatusFluent.CompletionTimeNested<A> withNewCompletionTimeLike(Time item) {
        return new CompletionTimeNestedImpl(item);
    }

    @Override
    public JobStatusFluent.CompletionTimeNested<A> editCompletionTime() {
        return this.withNewCompletionTimeLike(this.getCompletionTime());
    }

    @Override
    public JobStatusFluent.CompletionTimeNested<A> editOrNewCompletionTime() {
        return this.withNewCompletionTimeLike(this.getCompletionTime() != null ? this.getCompletionTime() : new TimeBuilder().build());
    }

    @Override
    public JobStatusFluent.CompletionTimeNested<A> editOrNewCompletionTimeLike(Time item) {
        return this.withNewCompletionTimeLike(this.getCompletionTime() != null ? this.getCompletionTime() : item);
    }

    @Override
    public A withNewCompletionTime(String time) {
        return this.withCompletionTime(new Time(time));
    }

    @Override
    public A addToConditions(int index, JobCondition item) {
        JobConditionBuilder builder = new JobConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, JobCondition item) {
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<JobCondition> items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<JobCondition> items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JobCondition> getConditions() {
        return JobStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<JobCondition> buildConditions() {
        return JobStatusFluentImpl.build(this.conditions);
    }

    @Override
    public JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<JobCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(JobCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index, JobCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    @Override
    public Boolean hasFailed() {
        return this.failed != null;
    }

    @Override
    @Deprecated
    public Time getStartTime() {
        return this.startTime != null ? this.startTime.build() : null;
    }

    @Override
    public Time buildStartTime() {
        return this.startTime != null ? this.startTime.build() : null;
    }

    @Override
    public A withStartTime(Time startTime) {
        this._visitables.remove(this.startTime);
        if (startTime != null) {
            this.startTime = new TimeBuilder(startTime);
            this._visitables.add(this.startTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public JobStatusFluent.StartTimeNested<A> withNewStartTime() {
        return new StartTimeNestedImpl();
    }

    @Override
    public JobStatusFluent.StartTimeNested<A> withNewStartTimeLike(Time item) {
        return new StartTimeNestedImpl(item);
    }

    @Override
    public JobStatusFluent.StartTimeNested<A> editStartTime() {
        return this.withNewStartTimeLike(this.getStartTime());
    }

    @Override
    public JobStatusFluent.StartTimeNested<A> editOrNewStartTime() {
        return this.withNewStartTimeLike(this.getStartTime() != null ? this.getStartTime() : new TimeBuilder().build());
    }

    @Override
    public JobStatusFluent.StartTimeNested<A> editOrNewStartTimeLike(Time item) {
        return this.withNewStartTimeLike(this.getStartTime() != null ? this.getStartTime() : item);
    }

    @Override
    public A withNewStartTime(String time) {
        return this.withStartTime(new Time(time));
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    @Override
    public Boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusFluentImpl that = (JobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.succeeded != null ? !this.succeeded.equals(that.succeeded) : that.succeeded != null);
    }

    public class StartTimeNestedImpl<N>
    extends TimeFluentImpl<JobStatusFluent.StartTimeNested<N>>
    implements JobStatusFluent.StartTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        StartTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        StartTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.withStartTime(this.builder.build());
        }

        @Override
        public N endStartTime() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>>
    implements JobStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final JobConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, JobCondition item) {
            this.index = index;
            this.builder = new JobConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new JobConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class CompletionTimeNestedImpl<N>
    extends TimeFluentImpl<JobStatusFluent.CompletionTimeNested<N>>
    implements JobStatusFluent.CompletionTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        CompletionTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        CompletionTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.withCompletionTime(this.builder.build());
        }

        @Override
        public N endCompletionTime() {
            return this.and();
        }
    }
}

