package io.fabric8.kubernetes.api.model.apiextensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceDefinitionSpecFluentImpl<A extends CustomResourceDefinitionSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CustomResourceDefinitionSpecFluent<A>{

    private String group;
    private CustomResourceDefinitionNamesBuilder names;
    private String scope;
    private String version;

    public CustomResourceDefinitionSpecFluentImpl(){
    }
    public CustomResourceDefinitionSpecFluentImpl(CustomResourceDefinitionSpec instance){
            this.withGroup(instance.getGroup()); 
            this.withNames(instance.getNames()); 
            this.withScope(instance.getScope()); 
            this.withVersion(instance.getVersion()); 
    }

    public String getGroup(){
            return this.group;
    }

    public A withGroup(String group){
            this.group=group; return (A) this;
    }

    public Boolean hasGroup(){
            return this.group!=null;
    }

    
/**
 * This method has been deprecated, please use method buildNames instead.
 */
@Deprecated public CustomResourceDefinitionNames getNames(){
            return this.names!=null?this.names.build():null;
    }

    public CustomResourceDefinitionNames buildNames(){
            return this.names!=null?this.names.build():null;
    }

    public A withNames(CustomResourceDefinitionNames names){
            _visitables.remove(this.names);
            if (names!=null){ this.names= new CustomResourceDefinitionNamesBuilder(names); _visitables.add(this.names);} return (A) this;
    }

    public Boolean hasNames(){
            return this.names!=null;
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames(){
            return new NamesNestedImpl();
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item){
            return new NamesNestedImpl(item);
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> editNames(){
            return withNewNamesLike(getNames());
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames(){
            return withNewNamesLike(getNames() != null ? getNames(): new CustomResourceDefinitionNamesBuilder().build());
    }

    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item){
            return withNewNamesLike(getNames() != null ? getNames(): item);
    }

    public String getScope(){
            return this.scope;
    }

    public A withScope(String scope){
            this.scope=scope; return (A) this;
    }

    public Boolean hasScope(){
            return this.scope!=null;
    }

    public String getVersion(){
            return this.version;
    }

    public A withVersion(String version){
            this.version=version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.version!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CustomResourceDefinitionSpecFluentImpl that = (CustomResourceDefinitionSpecFluentImpl) o;
            if (group != null ? !group.equals(that.group) :that.group != null) return false;
            if (names != null ? !names.equals(that.names) :that.names != null) return false;
            if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
            if (version != null ? !version.equals(that.version) :that.version != null) return false;
            return true;
    }


    public class NamesNestedImpl<N> extends CustomResourceDefinitionNamesFluentImpl<CustomResourceDefinitionSpecFluent.NamesNested<N>> implements CustomResourceDefinitionSpecFluent.NamesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CustomResourceDefinitionNamesBuilder builder;
    
            NamesNestedImpl(CustomResourceDefinitionNames item){
                    this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
            }
            NamesNestedImpl(){
                    this.builder = new CustomResourceDefinitionNamesBuilder(this);
            }
    
    public N and(){
            return (N) CustomResourceDefinitionSpecFluentImpl.this.withNames(builder.build());
    }
    public N endNames(){
            return and();
    }

}


}
