package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NetworkPolicySpecFluentImpl<A extends NetworkPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NetworkPolicySpecFluent<A>{

    private List<NetworkPolicyIngressRuleBuilder> ingress =  new ArrayList<NetworkPolicyIngressRuleBuilder>();
    private LabelSelectorBuilder podSelector;

    public NetworkPolicySpecFluentImpl(){
    }
    public NetworkPolicySpecFluentImpl(NetworkPolicySpec instance){
            this.withIngress(instance.getIngress()); 
            this.withPodSelector(instance.getPodSelector()); 
    }

    public A addToIngress(int index,NetworkPolicyIngressRule item){
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
    }

    public A setToIngress(int index,NetworkPolicyIngressRule item){
            NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
             return (A)this;
    }

    public A addToIngress(NetworkPolicyIngressRule... items){
            for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items){
            for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(NetworkPolicyIngressRule... items){
            for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (A)this;
    }

    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items){
            for (NetworkPolicyIngressRule item : items) {NetworkPolicyIngressRuleBuilder builder = new NetworkPolicyIngressRuleBuilder(item);_visitables.remove(builder);this.ingress.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIngress instead.
 */
@Deprecated public List<NetworkPolicyIngressRule> getIngress(){
            return build(ingress);
    }

    public List<NetworkPolicyIngressRule> buildIngress(){
            return build(ingress);
    }

    public NetworkPolicyIngressRule buildIngress(int index){
            return this.ingress.get(index).build();
    }

    public NetworkPolicyIngressRule buildFirstIngress(){
            return this.ingress.get(0).build();
    }

    public NetworkPolicyIngressRule buildLastIngress(){
            return this.ingress.get(ingress.size() - 1).build();
    }

    public NetworkPolicyIngressRule buildMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyIngressRuleBuilder> predicate){
            for (NetworkPolicyIngressRuleBuilder item: ingress) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withIngress(List<NetworkPolicyIngressRule> ingress){
            _visitables.removeAll(this.ingress);
            this.ingress.clear();
            if (ingress != null) {for (NetworkPolicyIngressRule item : ingress){this.addToIngress(item);}} return (A) this;
    }

    public A withIngress(NetworkPolicyIngressRule... ingress){
            this.ingress.clear(); if (ingress != null) {for (NetworkPolicyIngressRule item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public Boolean hasIngress(){
            return ingress!= null && !ingress.isEmpty();
    }

    public NetworkPolicySpecFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item){
            return new IngressNestedImpl(-1, item);
    }

    public NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index,NetworkPolicyIngressRule item){
            return new IngressNestedImpl(index, item);
    }

    public NetworkPolicySpecFluent.IngressNested<A> editIngress(int index){
            if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public NetworkPolicySpecFluent.IngressNested<A> editFirstIngress(){
            if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
            return setNewIngressLike(0, buildIngress(0));
    }

    public NetworkPolicySpecFluent.IngressNested<A> editLastIngress(){
            int index = ingress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyIngressRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<ingress.size();i++) { 
            if (predicate.apply(ingress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
            return setNewIngressLike(index, buildIngress(index));
    }

    
/**
 * This method has been deprecated, please use method buildPodSelector instead.
 */
@Deprecated public LabelSelector getPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public LabelSelector buildPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public A withPodSelector(LabelSelector podSelector){
            _visitables.remove(this.podSelector);
            if (podSelector!=null){ this.podSelector= new LabelSelectorBuilder(podSelector); _visitables.add(this.podSelector);} return (A) this;
    }

    public Boolean hasPodSelector(){
            return this.podSelector!=null;
    }

    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector(){
            return new PodSelectorNestedImpl();
    }

    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item){
            return new PodSelectorNestedImpl(item);
    }

    public NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector(){
            return withNewPodSelectorLike(getPodSelector());
    }

    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector(){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): new LabelSelectorBuilder().build());
    }

    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkPolicySpecFluentImpl that = (NetworkPolicySpecFluentImpl) o;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            if (podSelector != null ? !podSelector.equals(that.podSelector) :that.podSelector != null) return false;
            return true;
    }


    public class IngressNestedImpl<N> extends NetworkPolicyIngressRuleFluentImpl<NetworkPolicySpecFluent.IngressNested<N>> implements NetworkPolicySpecFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NetworkPolicyIngressRuleBuilder builder;
        private final int index;
    
            IngressNestedImpl(int index,NetworkPolicyIngressRule item){
                    this.index = index;
                    this.builder = new NetworkPolicyIngressRuleBuilder(this, item);
            }
            IngressNestedImpl(){
                    this.index = -1;
                    this.builder = new NetworkPolicyIngressRuleBuilder(this);
            }
    
    public N and(){
            return (N) NetworkPolicySpecFluentImpl.this.setToIngress(index, builder.build());
    }
    public N endIngress(){
            return and();
    }

}
    public class PodSelectorNestedImpl<N> extends LabelSelectorFluentImpl<NetworkPolicySpecFluent.PodSelectorNested<N>> implements NetworkPolicySpecFluent.PodSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LabelSelectorBuilder builder;
    
            PodSelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
            PodSelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) NetworkPolicySpecFluentImpl.this.withPodSelector(builder.build());
    }
    public N endPodSelector(){
            return and();
    }

}


}
