package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ThirdPartyResourceListFluent<A extends ThirdPartyResourceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,ThirdPartyResource item);
    public A setToItems(int index,ThirdPartyResource item);
    public A addToItems(ThirdPartyResource... items);
    public A addAllToItems(Collection<ThirdPartyResource> items);
    public A removeFromItems(ThirdPartyResource... items);
    public A removeAllFromItems(Collection<ThirdPartyResource> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<ThirdPartyResource> getItems();
    public List<ThirdPartyResource> buildItems();
    public ThirdPartyResource buildItem(int index);
    public ThirdPartyResource buildFirstItem();
    public ThirdPartyResource buildLastItem();
    public ThirdPartyResource buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ThirdPartyResourceBuilder> predicate);
    public A withItems(List<ThirdPartyResource> items);
    public A withItems(ThirdPartyResource... items);
    public Boolean hasItems();
    public ThirdPartyResourceListFluent.ItemsNested<A> addNewItem();
    public ThirdPartyResourceListFluent.ItemsNested<A> addNewItemLike(ThirdPartyResource item);
    public ThirdPartyResourceListFluent.ItemsNested<A> setNewItemLike(int index,ThirdPartyResource item);
    public ThirdPartyResourceListFluent.ItemsNested<A> editItem(int index);
    public ThirdPartyResourceListFluent.ItemsNested<A> editFirstItem();
    public ThirdPartyResourceListFluent.ItemsNested<A> editLastItem();
    public ThirdPartyResourceListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ThirdPartyResourceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public ThirdPartyResourceListFluent.MetadataNested<A> withNewMetadata();
    public ThirdPartyResourceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ThirdPartyResourceListFluent.MetadataNested<A> editMetadata();
    public ThirdPartyResourceListFluent.MetadataNested<A> editOrNewMetadata();
    public ThirdPartyResourceListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ThirdPartyResourceFluent<ThirdPartyResourceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ThirdPartyResourceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
