/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.RunAsGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.extensions.RunAsGroupStrategyOptionsFluent;
import io.fabric8.kubernetes.api.model.extensions.RunAsGroupStrategyOptionsFluentImpl;
import javax.validation.Validator;

public class RunAsGroupStrategyOptionsBuilder
extends RunAsGroupStrategyOptionsFluentImpl<RunAsGroupStrategyOptionsBuilder>
implements VisitableBuilder<RunAsGroupStrategyOptions, RunAsGroupStrategyOptionsBuilder> {
    RunAsGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RunAsGroupStrategyOptionsBuilder() {
        this(true);
    }

    public RunAsGroupStrategyOptionsBuilder(Boolean validationEnabled) {
        this(new RunAsGroupStrategyOptions(), validationEnabled);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RunAsGroupStrategyOptions(), validationEnabled);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent, RunAsGroupStrategyOptions instance) {
        this(fluent, instance, true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent, RunAsGroupStrategyOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRanges(instance.getRanges());
        fluent.withRule(instance.getRule());
        this.validationEnabled = validationEnabled;
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance) {
        this(instance, (Boolean)true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
        this.validationEnabled = validationEnabled;
    }

    public RunAsGroupStrategyOptionsBuilder(Validator validator) {
        this(new RunAsGroupStrategyOptions(), (Boolean)true);
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptionsFluent<?> fluent, RunAsGroupStrategyOptions instance, Validator validator) {
        this.fluent = fluent;
        fluent.withRanges(instance.getRanges());
        fluent.withRule(instance.getRule());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public RunAsGroupStrategyOptionsBuilder(RunAsGroupStrategyOptions instance, Validator validator) {
        this.fluent = this;
        this.withRanges(instance.getRanges());
        this.withRule(instance.getRule());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public RunAsGroupStrategyOptions build() {
        RunAsGroupStrategyOptions buildable = new RunAsGroupStrategyOptions(this.fluent.getRanges(), this.fluent.getRule());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunAsGroupStrategyOptionsBuilder that = (RunAsGroupStrategyOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

