package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ScaleStatusFluent<A extends ScaleStatusFluent<A>> extends Fluent<A>{


    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public Boolean hasSelector();
    public String getTargetSelector();
    public A withTargetSelector(String targetSelector);
    public Boolean hasTargetSelector();
    public A withNewTargetSelector(String arg1);
    public A withNewTargetSelector(StringBuilder arg1);
    public A withNewTargetSelector(StringBuffer arg1);



}
