package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CSIVolumeSourceFluent<A extends CSIVolumeSourceFluent<A>> extends Fluent<A>{


    public String getDriver();
    public A withDriver(String driver);
    public Boolean hasDriver();
    public A withNewDriver(String arg1);
    public A withNewDriver(StringBuilder arg1);
    public A withNewDriver(StringBuffer arg1);
    public String getFsType();
    public A withFsType(String fsType);
    public Boolean hasFsType();
    public A withNewFsType(String arg1);
    public A withNewFsType(StringBuilder arg1);
    public A withNewFsType(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildNodePublishSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getNodePublishSecretRef();
    public LocalObjectReference buildNodePublishSecretRef();
    public A withNodePublishSecretRef(LocalObjectReference nodePublishSecretRef);
    public Boolean hasNodePublishSecretRef();
    public A withNewNodePublishSecretRef(String name);
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef();
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(LocalObjectReference item);
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef();
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef();
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(LocalObjectReference item);
    public Boolean isReadOnly();
    public A withReadOnly(Boolean readOnly);
    public Boolean hasReadOnly();
    public A withNewReadOnly(String arg1);
    public A withNewReadOnly(boolean arg1);
    public A addToVolumeAttributes(String key,String value);
    public A addToVolumeAttributes(Map<String,String> map);
    public A removeFromVolumeAttributes(String key);
    public A removeFromVolumeAttributes(Map<String,String> map);
    public Map<String,String> getVolumeAttributes();
    public A withVolumeAttributes(Map<String,String> volumeAttributes);
    public Boolean hasVolumeAttributes();

    public interface NodePublishSecretRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<CSIVolumeSourceFluent.NodePublishSecretRefNested<N>>{

        
    public N and();    public N endNodePublishSecretRef();
}


}
