package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class AllowedCSIDriverBuilder extends AllowedCSIDriverFluentImpl<AllowedCSIDriverBuilder> implements VisitableBuilder<AllowedCSIDriver,AllowedCSIDriverBuilder>{

    AllowedCSIDriverFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public AllowedCSIDriverBuilder(){
            this(true);
    }
    public AllowedCSIDriverBuilder(Boolean validationEnabled){
            this(new AllowedCSIDriver(), validationEnabled);
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent){
            this(fluent, true);
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AllowedCSIDriver(), validationEnabled);
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance){
            this(fluent, instance, true);
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriver instance){
            this(instance,true);
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriver instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public AllowedCSIDriverBuilder(Validator validator){
            this(new AllowedCSIDriver(), true);
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriverFluent<?> fluent,AllowedCSIDriver instance,Validator validator){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public AllowedCSIDriverBuilder(AllowedCSIDriver instance,Validator validator){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public AllowedCSIDriver build(){
            AllowedCSIDriver buildable = new AllowedCSIDriver(fluent.getName());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AllowedCSIDriverBuilder that = (AllowedCSIDriverBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
