package io.fabric8.mockwebserver.crud;

public class Attribute {

    private final Key key;
    private final Value value;


    public Attribute(String key, String value) {
        this(new Key(key), new Value(value));
    }

    public Attribute(Key key, Value value) {
        this.key = key;
        this.value = value;
    }

    public Key getKey() {
        return key;
    }

    public Value getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Attribute attribute = (Attribute) o;

        if (key != null ? !key.equals(attribute.key) : attribute.key != null) return false;
        return value != null ? value.equals(attribute.value) : attribute.value == null;
    }

    @Override
    public int hashCode() {
        int result = key != null ? key.hashCode() : 0;
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "{" +
                "key:" + key +
                ", value:" + value +
                '}';
    }
}
