/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftConfig;
import java.net.MalformedURLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenShiftConfigTest {
    private Config kubernetesConfig;
    private String version;

    @Before
    public void setup() {
        this.kubernetesConfig = ((ConfigBuilder)new ConfigBuilder().withMasterUrl("https://2.2.2.2")).build();
        this.version = "v1";
        System.setProperty("kubernetes.oapi.version", this.version);
    }

    @After
    public void tearDown() {
        System.clearProperty("openshift.url");
        System.clearProperty("kubernetes.oapi.version");
    }

    @Test
    public void testOpenshiftURLAsRoot() {
        System.setProperty("openshift.url", "https://1.1.1.1");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)("https://1.1.1.1/oapi/" + this.version + "/"), (Object)config.getOpenShiftUrl());
    }

    @Test
    public void testOpenshiftURLAsRootWithSlash() {
        System.setProperty("openshift.url", "https://1.1.1.1/");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)("https://1.1.1.1/oapi/" + this.version + "/"), (Object)config.getOpenShiftUrl());
    }

    @Test
    public void testFullOpenshiftURL() {
        System.setProperty("openshift.url", "https://1.1.1.1/xxx");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)"https://1.1.1.1/xxx/", (Object)config.getOpenShiftUrl());
    }

    @Test
    public void testNoOpenshiftURL() {
        System.clearProperty("openshift.url");
        OpenShiftConfig config = new OpenShiftConfig(this.kubernetesConfig);
        Assert.assertEquals((Object)("https://2.2.2.2/oapi/" + this.version + "/"), (Object)config.getOpenShiftUrl());
    }

    @Test
    public void shouldInstantiateClientUsingSerializeDeserialize() throws MalformedURLException {
        DefaultOpenShiftClient original = new DefaultOpenShiftClient();
        String json = Serialization.asJson((Object)original.getConfiguration());
        DefaultOpenShiftClient copy = DefaultOpenShiftClient.fromConfig((String)json);
        Assert.assertEquals((Object)original.getConfiguration().getMasterUrl(), (Object)copy.getConfiguration().getMasterUrl());
        Assert.assertEquals((Object)original.getConfiguration().getOauthToken(), (Object)copy.getConfiguration().getOauthToken());
        Assert.assertEquals((Object)original.getConfiguration().getNamespace(), (Object)copy.getConfiguration().getNamespace());
        Assert.assertEquals((Object)original.getConfiguration().getUsername(), (Object)copy.getConfiguration().getUsername());
        Assert.assertEquals((Object)original.getConfiguration().getPassword(), (Object)copy.getConfiguration().getPassword());
    }
}

