/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.connection;

import io.fluxcapacitor.common.TimingUtils;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;

public class SingleSessionSupplier
implements Supplier<Session> {
    private final ClientManager client;
    private final AtomicReference<Session> session = new AtomicReference();
    private final URI endpointUri;
    private final Object endpoint;
    private final Duration reconnectDelay;

    public SingleSessionSupplier(URI endpointUri, Object endpoint) {
        this(ClientManager.createClient(), endpointUri, endpoint, Duration.ofSeconds(1L));
    }

    public SingleSessionSupplier(ClientManager client, URI endpointUri, Object endpoint, Duration reconnectDelay) {
        this.client = client;
        this.endpointUri = endpointUri;
        this.endpoint = endpoint;
        this.reconnectDelay = reconnectDelay;
    }

    @Override
    public Session get() {
        return this.session.updateAndGet(s -> {
            while (s == null || !s.isOpen()) {
                s = (Session)TimingUtils.retryOnFailure(() -> this.client.connectToServer(this.endpoint, this.endpointUri), (Duration)this.reconnectDelay);
            }
            return s;
        });
    }
}

