/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.upcasting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcast;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.stream.Stream;

public class AnnotatedUpcaster<T> {
    private final Method method;
    private final Upcast annotation;
    private final Function<Data<T>, Stream<Data<T>>> upcastFunction;

    public AnnotatedUpcaster(Method method, Function<Data<T>, Stream<Data<T>>> upcastFunction) {
        this.method = method;
        this.annotation = method.getAnnotation(Upcast.class);
        this.upcastFunction = upcastFunction;
    }

    public Stream<Data<T>> upcast(Data<T> input) {
        return this.annotation.type().equals(input.getType()) && this.annotation.revision() == input.getRevision() ? this.upcastFunction.apply(input) : Stream.of(input);
    }

    public Upcast getAnnotation() {
        return this.annotation;
    }

    public String toString() {
        return this.method.toString();
    }
}

