/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.upcasting;

import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.AnnotatedUpcaster;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Converter;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcast;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.UpcastInspector;
import io.fluxcapacitor.javaclient.common.serialization.upcasting.Upcaster;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpcasterChain<T>
implements Upcaster<Data<T>> {
    private final Map<DataRevision, AnnotatedUpcaster<T>> upcasters;

    public static <T> Upcaster<Data<byte[]>> create(Collection<?> upcasters, Converter<T> converter) {
        if (upcasters.isEmpty()) {
            return s -> s;
        }
        Upcaster upcasterChain = UpcasterChain.create(upcasters, converter.getDataType());
        return stream -> {
            Stream<Data> converted = stream.map(d -> new Data(converter.convert((byte[])d.getValue()), d.getType(), d.getRevision()));
            Stream<Data> upcasted = upcasterChain.upcast(converted);
            return upcasted.map(d -> new Data((Object)converter.convert(d.getValue()), d.getType(), d.getRevision()));
        };
    }

    public static <T> Upcaster<Data<T>> create(Collection<?> upcasters, Class<T> dataType) {
        if (upcasters.isEmpty()) {
            return s -> s;
        }
        return new UpcasterChain<T>(UpcastInspector.inspect(upcasters, dataType));
    }

    protected UpcasterChain(Collection<AnnotatedUpcaster<T>> upcasters) {
        this.upcasters = upcasters.stream().collect(Collectors.toMap(u -> new DataRevision(u.getAnnotation()), Function.identity(), (a, b) -> {
            throw new IllegalArgumentException(String.format("Failed to create upcaster chain. Methods '%s' and '%s' both apply to the same data revision.", a, b));
        }));
    }

    @Override
    public Stream<Data<T>> upcast(Stream<Data<T>> input) {
        return input.flatMap(i -> Optional.ofNullable(this.upcasters.get(new DataRevision((Data<?>)i))).map(upcaster -> this.upcast(upcaster.upcast(i))).orElse(Stream.of(i)));
    }

    protected static final class DataRevision {
        private final String type;
        private final int revision;

        protected DataRevision(Data<?> data) {
            this(data.getType(), data.getRevision());
        }

        protected DataRevision(Upcast annotation) {
            this(annotation.type(), annotation.revision());
        }

        public String getType() {
            return this.type;
        }

        public int getRevision() {
            return this.revision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataRevision)) {
                return false;
            }
            DataRevision other = (DataRevision)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            return this.getRevision() == other.getRevision();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + this.getRevision();
            return result;
        }

        public String toString() {
            return "UpcasterChain.DataRevision(type=" + this.getType() + ", revision=" + this.getRevision() + ")";
        }

        @ConstructorProperties(value={"type", "revision"})
        public DataRevision(String type, int revision) {
            this.type = type;
            this.revision = revision;
        }
    }
}

