/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.keyvalue.websocket;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.keyvalue.DeleteValue;
import io.fluxcapacitor.common.api.keyvalue.GetValue;
import io.fluxcapacitor.common.api.keyvalue.GetValueResult;
import io.fluxcapacitor.common.api.keyvalue.KeyValuePair;
import io.fluxcapacitor.common.api.keyvalue.StoreValues;
import io.fluxcapacitor.common.serialization.websocket.JsonDecoder;
import io.fluxcapacitor.common.serialization.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.common.connection.AbstractWebsocketService;
import io.fluxcapacitor.javaclient.keyvalue.KeyValueService;
import java.net.URI;
import java.util.List;
import javax.websocket.ClientEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketKeyValueService
extends AbstractWebsocketService
implements KeyValueService {
    private static final Logger log = LoggerFactory.getLogger(WebsocketKeyValueService.class);
    private final Backlog<KeyValuePair> backlog = new Backlog(this::storeValues);

    public WebsocketKeyValueService(String endPointUrl) {
        this(URI.create(endPointUrl));
    }

    public WebsocketKeyValueService(URI endpointUri) {
        super(endpointUri);
    }

    protected Awaitable storeValues(List<KeyValuePair> keyValuePairs) throws Exception {
        this.getSession().getBasicRemote().sendObject((Object)new StoreValues(keyValuePairs));
        return Awaitable.ready();
    }

    @Override
    public Awaitable putValue(String key, Data<byte[]> value) {
        return this.backlog.add((Object[])new KeyValuePair[]{new KeyValuePair(key, value)});
    }

    @Override
    public Data<byte[]> getValue(String key) {
        GetValueResult result = (GetValueResult)this.sendRequest((Request)new GetValue(key));
        return result.getValue();
    }

    @Override
    public Awaitable deleteValue(String key) {
        try {
            this.getSession().getBasicRemote().sendObject((Object)new DeleteValue(key));
        }
        catch (Exception e) {
            log.warn("Could not delete value {}", (Object)key, (Object)e);
            return () -> {
                throw e;
            };
        }
        return () -> {};
    }
}

