/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Message;
import io.fluxcapacitor.javaclient.tracking.ConsumerService;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import io.fluxcapacitor.javaclient.tracking.TrackingConfiguration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Tracking {
    public static Registration start(String name, ConsumerService consumerService, Consumer<List<Message>> consumer) {
        return Tracking.start(name, 1, consumerService, consumer);
    }

    public static Registration start(String name, int threads, ConsumerService consumerService, Consumer<List<Message>> consumer) {
        return Tracking.start(name, consumer, consumerService, TrackingConfiguration.builder().threads(threads).build());
    }

    public static Registration start(String consumerName, Consumer<List<Message>> consumer, ConsumerService consumerService, TrackingConfiguration configuration) {
        List<Tracker> instances = IntStream.range(0, configuration.getThreads()).mapToObj(i -> new Tracker(consumerName, i, configuration, consumer, consumerService)).collect(Collectors.toList());
        ExecutorService executor = Executors.newFixedThreadPool(configuration.getThreads());
        instances.forEach(executor::submit);
        return () -> {
            instances.forEach(Tracker::cancel);
            executor.shutdown();
            return true;
        };
    }
}

