/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.Interceptor;
import io.fluxcapacitor.common.api.Message;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TrackingConfiguration {
    private final List<Interceptor<List<Message>, Void>> batchInterceptors;
    private int threads;
    private int maxFetchBatchSize;
    private int maxConsumerBatchSize;
    private Duration maxWaitDuration;
    private Duration retryDelay;

    private static int $default$threads() {
        return 1;
    }

    private static int $default$maxFetchBatchSize() {
        return 1024;
    }

    private static int $default$maxConsumerBatchSize() {
        return 1024;
    }

    private static Duration $default$maxWaitDuration() {
        return Duration.ofSeconds(60L);
    }

    private static Duration $default$retryDelay() {
        return Duration.ofSeconds(1L);
    }

    @ConstructorProperties(value={"batchInterceptors", "threads", "maxFetchBatchSize", "maxConsumerBatchSize", "maxWaitDuration", "retryDelay"})
    TrackingConfiguration(List<Interceptor<List<Message>, Void>> batchInterceptors, int threads, int maxFetchBatchSize, int maxConsumerBatchSize, Duration maxWaitDuration, Duration retryDelay) {
        this.batchInterceptors = batchInterceptors;
        this.threads = threads;
        this.maxFetchBatchSize = maxFetchBatchSize;
        this.maxConsumerBatchSize = maxConsumerBatchSize;
        this.maxWaitDuration = maxWaitDuration;
        this.retryDelay = retryDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().batchInterceptors(this.batchInterceptors).threads(this.threads).maxFetchBatchSize(this.maxFetchBatchSize).maxConsumerBatchSize(this.maxConsumerBatchSize).maxWaitDuration(this.maxWaitDuration).retryDelay(this.retryDelay);
    }

    public List<Interceptor<List<Message>, Void>> getBatchInterceptors() {
        return this.batchInterceptors;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getMaxFetchBatchSize() {
        return this.maxFetchBatchSize;
    }

    public int getMaxConsumerBatchSize() {
        return this.maxConsumerBatchSize;
    }

    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public static class Builder {
        private ArrayList<Interceptor<List<Message>, Void>> batchInterceptors;
        private boolean threads$set;
        private int threads;
        private boolean maxFetchBatchSize$set;
        private int maxFetchBatchSize;
        private boolean maxConsumerBatchSize$set;
        private int maxConsumerBatchSize;
        private boolean maxWaitDuration$set;
        private Duration maxWaitDuration;
        private boolean retryDelay$set;
        private Duration retryDelay;

        Builder() {
        }

        public Builder batchInterceptor(Interceptor<List<Message>, Void> batchInterceptor) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.add(batchInterceptor);
            return this;
        }

        public Builder batchInterceptors(Collection<? extends Interceptor<List<Message>, Void>> batchInterceptors) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.addAll(batchInterceptors);
            return this;
        }

        public Builder clearBatchInterceptors() {
            if (this.batchInterceptors != null) {
                this.batchInterceptors.clear();
            }
            return this;
        }

        public Builder threads(int threads) {
            this.threads = threads;
            this.threads$set = true;
            return this;
        }

        public Builder maxFetchBatchSize(int maxFetchBatchSize) {
            this.maxFetchBatchSize = maxFetchBatchSize;
            this.maxFetchBatchSize$set = true;
            return this;
        }

        public Builder maxConsumerBatchSize(int maxConsumerBatchSize) {
            this.maxConsumerBatchSize = maxConsumerBatchSize;
            this.maxConsumerBatchSize$set = true;
            return this;
        }

        public Builder maxWaitDuration(Duration maxWaitDuration) {
            this.maxWaitDuration = maxWaitDuration;
            this.maxWaitDuration$set = true;
            return this;
        }

        public Builder retryDelay(Duration retryDelay) {
            this.retryDelay = retryDelay;
            this.retryDelay$set = true;
            return this;
        }

        public TrackingConfiguration build() {
            List<Interceptor<List<Message>, Void>> batchInterceptors;
            switch (this.batchInterceptors == null ? 0 : this.batchInterceptors.size()) {
                case 0: {
                    batchInterceptors = Collections.emptyList();
                    break;
                }
                case 1: {
                    batchInterceptors = Collections.singletonList(this.batchInterceptors.get(0));
                    break;
                }
                default: {
                    batchInterceptors = Collections.unmodifiableList(new ArrayList<Interceptor<List<Message>, Void>>(this.batchInterceptors));
                }
            }
            return new TrackingConfiguration(batchInterceptors, this.threads$set ? this.threads : TrackingConfiguration.$default$threads(), this.maxFetchBatchSize$set ? this.maxFetchBatchSize : TrackingConfiguration.$default$maxFetchBatchSize(), this.maxConsumerBatchSize$set ? this.maxConsumerBatchSize : TrackingConfiguration.$default$maxConsumerBatchSize(), this.maxWaitDuration$set ? this.maxWaitDuration : TrackingConfiguration.$default$maxWaitDuration(), this.retryDelay$set ? this.retryDelay : TrackingConfiguration.$default$retryDelay());
        }

        public String toString() {
            return "TrackingConfiguration.Builder(batchInterceptors=" + this.batchInterceptors + ", threads=" + this.threads + ", maxFetchBatchSize=" + this.maxFetchBatchSize + ", maxConsumerBatchSize=" + this.maxConsumerBatchSize + ", maxWaitDuration=" + this.maxWaitDuration + ", retryDelay=" + this.retryDelay + ")";
        }
    }
}

