/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.websocket;

import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.api.tracking.ReadResult;
import io.fluxcapacitor.common.api.tracking.StorePosition;
import io.fluxcapacitor.common.serialization.websocket.JsonDecoder;
import io.fluxcapacitor.common.serialization.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.common.connection.AbstractWebsocketService;
import io.fluxcapacitor.javaclient.tracking.ConsumerService;
import java.net.URI;
import java.time.Duration;
import javax.websocket.ClientEndpoint;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketConsumerService
extends AbstractWebsocketService
implements ConsumerService {
    public WebsocketConsumerService(String endPointUrl) {
        this(URI.create(endPointUrl));
    }

    public WebsocketConsumerService(URI endPointUri) {
        super(endPointUri);
    }

    @Override
    public MessageBatch read(String processor, int channel, int maxSize, Duration maxTimeout) {
        ReadResult readResult = (ReadResult)this.sendRequest((Request)new Read(processor, channel, maxSize, maxTimeout.toMillis()));
        return readResult.getMessageBatch();
    }

    @Override
    public void storePosition(String processor, int[] segment, long lastIndex) {
        try {
            this.getSession().getBasicRemote().sendObject((Object)new StorePosition(processor, segment, lastIndex));
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Failed to store position of processor %s", processor), e);
        }
    }
}

