/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.websocket;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Message;
import io.fluxcapacitor.common.api.tracking.Append;
import io.fluxcapacitor.common.serialization.websocket.JsonDecoder;
import io.fluxcapacitor.common.serialization.websocket.JsonEncoder;
import io.fluxcapacitor.javaclient.common.connection.AbstractWebsocketService;
import io.fluxcapacitor.javaclient.tracking.ProducerService;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import javax.websocket.ClientEndpoint;
import javax.websocket.EncodeException;

@ClientEndpoint(encoders={JsonEncoder.class}, decoders={JsonDecoder.class})
public class WebsocketProducerService
extends AbstractWebsocketService
implements ProducerService {
    private final Backlog<Message> backlog;

    public WebsocketProducerService(String endPointUrl) {
        this(URI.create(endPointUrl), 1024);
    }

    public WebsocketProducerService(String endPointUrl, int backlogSize) {
        this(URI.create(endPointUrl), backlogSize);
    }

    public WebsocketProducerService(URI endPointUri, int backlogSize) {
        super(endPointUri);
        this.backlog = new Backlog(this::doSend, backlogSize);
    }

    @Override
    public Awaitable send(Message ... messages) {
        return this.backlog.add((Object[])messages);
    }

    public Registration registerMonitor(Consumer<Message> monitor) {
        return this.backlog.registerMonitor(messages -> messages.forEach(monitor));
    }

    private Awaitable doSend(List<Message> messages) throws IOException, EncodeException {
        this.getSession().getBasicRemote().sendObject((Object)new Append(messages));
        return Awaitable.ready();
    }
}

