/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.benchmark;

import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import java.util.concurrent.CountDownLatch;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBenchmark {
    private static final Logger log = LoggerFactory.getLogger(AbstractClientBenchmark.class);
    private final CountDownLatch commandCountDownLatch;
    private final WebSocketClient.Properties clientProperties;
    private final int commandCount;

    public AbstractClientBenchmark(int commandCount, WebSocketClient.Properties clientProperties) {
        this.commandCount = commandCount;
        this.commandCountDownLatch = new CountDownLatch(commandCount);
        this.clientProperties = clientProperties;
    }

    public AbstractClientBenchmark(int commandCount) {
        this(commandCount, new WebSocketClient.Properties("benchmark", "ws://localhost:8080"));
    }

    protected void testCommands() {
        int count = (int)this.commandCountDownLatch.getCount();
        log.info("Start sending {} commands", (Object)count);
        TimingUtils.time(() -> {
            IntStream.range(0, count).forEach(i -> this.doSendCommand("payload" + i));
            try {
                this.commandCountDownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }, duration -> log.info("Finished sending and handling {} commands in {}ms", (Object)count, duration));
    }

    protected int getCommandCount() {
        return this.commandCount;
    }

    protected abstract void doSendCommand(String var1);

    public CountDownLatch getCommandCountDownLatch() {
        return this.commandCountDownLatch;
    }

    public WebSocketClient.Properties getClientProperties() {
        return this.clientProperties;
    }
}

