/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.test.GivenWhenThenAssertionError;
import io.fluxcapacitor.javaclient.test.Then;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultValidator
implements Then {
    private static final Logger log = LoggerFactory.getLogger(AbstractResultValidator.class);
    private final Object actualResult;

    protected Then expectMessages(Collection<?> expected, Collection<Message> actual) {
        if (!this.containsAll(expected, actual)) {
            this.reportMismatch(expected, actual);
        }
        return this;
    }

    protected Then expectOnlyMessages(Collection<?> expected, Collection<Message> actual) {
        if (expected.size() != actual.size()) {
            this.reportMismatch(expected, actual);
        } else if (!this.containsAll(expected, actual)) {
            this.reportMismatch(expected, actual);
        }
        return this;
    }

    protected Then expectNoMessagesLike(Collection<?> expectedNotToGet, Collection<Message> actual) {
        if (this.containsAny(expectedNotToGet, actual)) {
            this.reportUnwantedMatch(expectedNotToGet, actual);
        }
        return this;
    }

    protected void reportMismatch(Collection<?> expected, Collection<Message> actual) {
        if (this.actualResult instanceof Throwable) {
            throw new GivenWhenThenAssertionError("Published messages did not match. Probable cause is an exception that occurred during handling:", (Throwable)this.actualResult);
        }
        throw new GivenWhenThenAssertionError(String.format("Published messages did not match.\nExpected: %s\nGot: %s\n\n", expected, actual), expected, actual);
    }

    protected void reportUnwantedMatch(Collection<?> expected, Collection<Message> actual) {
        if (this.actualResult instanceof Throwable) {
            throw new GivenWhenThenAssertionError("An exception occurred during handling:", (Throwable)this.actualResult);
        }
        throw new GivenWhenThenAssertionError(String.format("Unwanted match found in published messages.\nExpected not to get: %s\nGot: %s\n\n", expected, actual), expected, actual);
    }

    protected boolean containsAll(Collection<?> expected, Collection<Message> actual) {
        return expected.stream().allMatch(e -> actual.stream().anyMatch(a -> this.matches(e, (Message)a)));
    }

    protected boolean containsAny(Collection<?> expected, Collection<Message> actual) {
        return expected.stream().anyMatch(e -> actual.stream().anyMatch(a -> this.matches(e, (Message)a)));
    }

    protected boolean matches(Object expected, Message actual) {
        if (expected instanceof Matcher) {
            return ((Matcher)expected).matches(actual.getPayload()) || ((Matcher)expected).matches((Object)actual);
        }
        Message expectedMessage = (Message)expected;
        return expectedMessage.getPayload().equals(actual.getPayload()) && actual.getMetadata().entrySet().containsAll(expectedMessage.getMetadata().entrySet());
    }

    protected Collection<?> asMessages(Collection<?> events, MessageType type) {
        return events.stream().map(e -> e instanceof Matcher ? (Matcher)e : (e instanceof Message ? (Message)e : new Message(e, type))).collect(Collectors.toList());
    }

    @Override
    public Then expectResult(Matcher<?> resultMatcher) {
        StringDescription description = new StringDescription();
        resultMatcher.describeTo((Description)description);
        if (this.actualResult instanceof Throwable) {
            throw new GivenWhenThenAssertionError(String.format("Handler threw an unexpected exception. Expected: %s", description), (Throwable)this.actualResult);
        }
        if (!resultMatcher.matches(this.actualResult)) {
            throw new GivenWhenThenAssertionError(String.format("Handler returned an unexpected value.\nExpected: %s\nGot: %s", description, this.actualResult));
        }
        return this;
    }

    @Override
    public Then expectNoResultLike(Matcher<?> resultMatcher) {
        StringDescription description = new StringDescription();
        resultMatcher.describeTo((Description)description);
        if (this.actualResult instanceof Throwable) {
            throw new GivenWhenThenAssertionError(String.format("Handler threw an unexpected exception. Expected: %s", description), (Throwable)this.actualResult);
        }
        if (resultMatcher.matches(this.actualResult)) {
            throw new GivenWhenThenAssertionError(String.format("Handler did return the unwanted result.\nExpected not to get: %s\nGot: %s", description, this.actualResult));
        }
        return this;
    }

    @Override
    public Then verify(Runnable check) {
        try {
            check.run();
        }
        catch (Exception e) {
            throw new GivenWhenThenAssertionError("Verify check failed", e);
        }
        return this;
    }

    @Override
    public Then expectException(Matcher<?> resultMatcher) {
        StringDescription description = new StringDescription();
        resultMatcher.describeTo((Description)description);
        if (!(this.actualResult instanceof Throwable)) {
            throw new GivenWhenThenAssertionError(String.format("Handler returned normally but an exception was expected. Expected: %s. Got: %s", description, this.actualResult));
        }
        if (!resultMatcher.matches(this.actualResult)) {
            throw new GivenWhenThenAssertionError(String.format("Handler returned unexpected value.\nExpected: %s\nGot: %s", description, this.actualResult));
        }
        return this;
    }

    @ConstructorProperties(value={"actualResult"})
    public AbstractResultValidator(Object actualResult) {
        this.actualResult = actualResult;
    }
}

