/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test.streaming;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.configuration.DefaultFluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.FluxCapacitorBuilder;
import io.fluxcapacitor.javaclient.test.AbstractTestFixture;
import io.fluxcapacitor.javaclient.test.Then;
import io.fluxcapacitor.javaclient.test.streaming.AsyncResultValidator;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class StreamingTestFixture
extends AbstractTestFixture {
    private final BlockingQueue<Message> events = new LinkedBlockingQueue<Message>();
    private final BlockingQueue<Message> commands = new LinkedBlockingQueue<Message>();
    private final ScheduledExecutorService deregistrationService = Executors.newSingleThreadScheduledExecutor();

    public static StreamingTestFixture create(Object ... handlers) {
        return new StreamingTestFixture((FluxCapacitorBuilder)DefaultFluxCapacitor.builder(), fc -> Arrays.asList(handlers));
    }

    public static StreamingTestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Object ... handlers) {
        return new StreamingTestFixture(fluxCapacitorBuilder, fc -> Arrays.asList(handlers));
    }

    public static StreamingTestFixture create(Function<FluxCapacitor, List<?>> handlersFactory) {
        return new StreamingTestFixture((FluxCapacitorBuilder)DefaultFluxCapacitor.builder(), handlersFactory);
    }

    public static StreamingTestFixture create(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        return new StreamingTestFixture(fluxCapacitorBuilder, handlersFactory);
    }

    protected StreamingTestFixture(FluxCapacitorBuilder fluxCapacitorBuilder, Function<FluxCapacitor, List<?>> handlersFactory) {
        super(fluxCapacitorBuilder, handlersFactory);
    }

    @Override
    public Registration registerHandlers(List<?> handlers) {
        return this.getFluxCapacitor().startTracking(handlers);
    }

    @Override
    public void deregisterHandlers(Registration registration) {
        this.deregistrationService.schedule(() -> ((Registration)registration).cancel(), 1L, TimeUnit.SECONDS);
    }

    @Override
    protected Then createResultValidator(Object result) {
        return new AsyncResultValidator(result, this.events, this.commands);
    }

    @Override
    protected void registerCommand(Message command) {
        this.commands.add(command);
    }

    @Override
    protected void registerEvent(Message event) {
        this.events.add(event);
    }

    @Override
    protected Object getDispatchResult(CompletableFuture<?> dispatchResult) {
        try {
            return dispatchResult.get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

