/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.TimeHelper$;
import io.gatling.core.stats.message.End$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.DataWriterMessage;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.GroupMessage;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LeakData;
import io.gatling.core.stats.writer.LeakReporterDataWriter$lambda$$onFlush$1;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.UserMessage;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u001b\t1B*Z1l%\u0016\u0004xN\u001d;fe\u0012\u000bG/Y,sSR,'O\u0003\u0002\u0004\t\u00051qO]5uKJT!!\u0002\u0004\u0002\u000bM$\u0018\r^:\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\u000f!\ry\u0001CE\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u000b\t\u0006$\u0018m\u0016:ji\u0016\u0014\bCA\b\u0014\u0013\t!\"A\u0001\u0005MK\u0006\\G)\u0019;b\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004\u0005\u0002\u0010\u0001!9!\u0004\u0001b\u0001\n\u0013Y\u0012A\u00044mkNDG+[7fe:\u000bW.Z\u000b\u00029A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB*ue&tw\r\u0003\u0004&\u0001\u0001\u0006I\u0001H\u0001\u0010M2,8\u000f\u001b+j[\u0016\u0014h*Y7fA!)q\u0005\u0001C\u0001Q\u00051qN\\%oSR$\"AE\u0015\t\u000b)2\u0003\u0019A\u0016\u0002\t%t\u0017\u000e\u001e\t\u0003\u001f1J!!\f\u0002\u0003\t%s\u0017\u000e\u001e\u0005\u0006_\u0001!\t\u0005M\u0001\b_:4E.^:i)\t\tt\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0003V]&$\b\"\u0002\u001d/\u0001\u0004\u0011\u0012\u0001\u00023bi\u0006DQA\u000f\u0001\u0005\nm\nQb\u001c8Vg\u0016\u0014X*Z:tC\u001e,GcA\u0019=\u0003\")Q(\u000fa\u0001}\u0005!Qo]3s!\tyq(\u0003\u0002A\u0005\tYQk]3s\u001b\u0016\u001c8/Y4f\u0011\u0015A\u0014\b1\u0001\u0013\u0011\u0015\u0019\u0005\u0001\"\u0003E\u00039ygn\u0012:pkBlUm]:bO\u0016$2!M#K\u0011\u00151%\t1\u0001H\u0003\u00159'o\\;q!\ty\u0001*\u0003\u0002J\u0005\taqI]8va6+7o]1hK\")\u0001H\u0011a\u0001%!)A\n\u0001C\u0005\u001b\u0006\trN\u001c*fgB|gn]3NKN\u001c\u0018mZ3\u0015\u0007Er5\u000bC\u0003P\u0017\u0002\u0007\u0001+\u0001\u0005sKN\u0004xN\\:f!\ty\u0011+\u0003\u0002S\u0005\ty!+Z:q_:\u001cX-T3tg\u0006<W\rC\u00039\u0017\u0002\u0007!\u0003C\u0003V\u0001\u0011\u0005c+A\u0005p]6+7o]1hKR\u0019\u0011g\u0016/\t\u000ba#\u0006\u0019A-\u0002\u000f5,7o]1hKB\u0011qBW\u0005\u00037\n\u0011\u0001\u0003T8bI\u00163XM\u001c;NKN\u001c\u0018mZ3\t\u000ba\"\u0006\u0019\u0001\n\t\u000by\u0003A\u0011I0\u0002\u000f=t7I]1tQR\u0019\u0011\u0007\u00195\t\u000b\u0005l\u0006\u0019\u00012\u0002\u000b\r\fWo]3\u0011\u0005\r4gB\u0001\u001ae\u0013\t)7'\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u001dT!!Z\u001a\t\u000baj\u0006\u0019\u0001\n\t\u000b)\u0004A\u0011I6\u0002\r=t7\u000b^8q)\t\tD\u000eC\u00039S\u0002\u0007!\u0003")
public class LeakReporterDataWriter
extends DataWriter<LeakData> {
    private final String flushTimerName;

    private String flushTimerName() {
        return this.flushTimerName;
    }

    @Override
    public LeakData onInit(Init init) {
        FiniteDuration noActivityTimeout = new package.DurationInt(package$.MODULE$.DurationInt(init.configuration().data().leak().noActivityTimeout())).seconds();
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, noActivityTimeout, true);
        return new LeakData(noActivityTimeout, TimeHelper$.MODULE$.nowMillis(), (Map<Object, DataWriterMessage>)Map$.MODULE$.empty());
    }

    @Override
    public void onFlush(LeakData data) {
        block0: {
            long timeSinceLastTouch = (TimeHelper$.MODULE$.nowMillis() - data.lastTouch()) / 1000L;
            if (timeSinceLastTouch <= data.noActivityTimeout().toSeconds() || !data.events().nonEmpty()) break block0;
            System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Gatling had no activity during last ", ". It could be a virtual user leak, here's their last events:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{data.noActivityTimeout()})));
            data.events().values().foreach((Function1)new LeakReporterDataWriter$lambda$$onFlush$1());
        }
    }

    private void onUserMessage(UserMessage user, LeakData data) {
        data.lastTouch_$eq(TimeHelper$.MODULE$.nowMillis());
        MessageEvent messageEvent = user.event();
        if (Start$.MODULE$.equals(messageEvent)) {
            data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)user.session().userId())), (Object)user));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (End$.MODULE$.equals(messageEvent)) {
            data.events().$minus$eq((Object)BoxesRunTime.boxToLong((long)user.session().userId()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)messageEvent);
        }
    }

    private void onGroupMessage(GroupMessage group, LeakData data) {
        data.lastTouch_$eq(TimeHelper$.MODULE$.nowMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)group.userId())), (Object)group));
    }

    private void onResponseMessage(ResponseMessage response, LeakData data) {
        data.lastTouch_$eq(TimeHelper$.MODULE$.nowMillis());
        data.events().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)response.userId())), (Object)response));
    }

    @Override
    public void onMessage(LoadEventMessage message, LeakData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof GroupMessage) {
            GroupMessage groupMessage = (GroupMessage)loadEventMessage;
            this.onGroupMessage(groupMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)loadEventMessage);
        }
    }

    @Override
    public void onCrash(String cause, LeakData data) {
    }

    @Override
    public void onStop(LeakData data) {
        this.cancelTimer(this.flushTimerName());
    }

    public static final /* synthetic */ void io$gatling$core$stats$writer$LeakReporterDataWriter$$$anonfun$1(Object x$1) {
        System.err.println(x$1);
    }

    public LeakReporterDataWriter() {
        super(ClassTag$.MODULE$.apply(LeakData.class));
        this.flushTimerName = "flushTimer";
    }
}

