/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.http.fetch.CssParser$lambda$$extractResources$1;
import io.gatling.http.fetch.CssParser$lambda$$extractUrls$1;
import io.gatling.http.fetch.CssParser$lambda$$extractUrls$2;
import io.gatling.http.fetch.CssParser$lambda$$io$gatling$http$fetch$CssParser$$$nestedInAnonfun$3$1;
import io.gatling.http.fetch.CssResource;
import io.gatling.http.fetch.EmbeddedResource;
import io.gatling.http.util.HttpHelper$;
import org.asynchttpclient.uri.Uri;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class CssParser$
implements StrictLogging {
    public static final CssParser$ MODULE$;
    private final Regex InlineStyleImageUrls;
    private final Regex StyleImportsUrls;
    private final Some<Object> SingleQuoteEscapeChar;
    private final Some<Object> DoubleQuoteEscapeChar;
    private final char[] AtImportChars;
    private final char[] UrlStartChars;
    private final Logger logger;

    static {
        new CssParser$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Regex InlineStyleImageUrls() {
        return this.InlineStyleImageUrls;
    }

    public Regex StyleImportsUrls() {
        return this.StyleImportsUrls;
    }

    public Iterator<String> extractUrls(CharSequence string, Regex regex) {
        return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)regex.findAllIn(string).matchData().map((Function1)new CssParser$lambda$$extractUrls$1(this)), (Function1)new CssParser$lambda$$extractUrls$2()).flatten();
    }

    public Some<Object> SingleQuoteEscapeChar() {
        return this.SingleQuoteEscapeChar;
    }

    public Some<Object> DoubleQuoteEscapeChar() {
        return this.DoubleQuoteEscapeChar;
    }

    public char[] AtImportChars() {
        return this.AtImportChars;
    }

    public char[] UrlStartChars() {
        return this.UrlStartChars;
    }

    public Option<String> extractUrl(String string, int start2, int end) {
        Object object;
        if (string.isEmpty()) {
            object = None$.MODULE$;
        } else {
            ObjectRef protectChar = ObjectRef.create((Object)None$.MODULE$);
            BooleanRef broken = BooleanRef.create((boolean)false);
            int trimmedStart = this.trimLeft$1(start2, string, end, protectChar, broken);
            int trimmedEnd = this.trimRight$1(end, trimmedStart, string, protectChar, broken);
            if (!broken.elem && trimmedStart != trimmedEnd) {
                object = string.charAt(trimmedStart) == '#' ? None$.MODULE$ : new Some((Object)string.substring(trimmedStart, trimmedEnd));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"css url ", " broken"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = None$.MODULE$;
            }
        }
        return object;
    }

    public List<EmbeddedResource> extractResources(Uri cssURI, String cssContent) {
        ArrayBuffer resources2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean withinComment = false;
        BooleanRef withinImport = BooleanRef.create((boolean)false);
        BooleanRef withinUrl = BooleanRef.create((boolean)false);
        int urlStart = 0;
        block6: for (int i = 0; i < cssContent.length(); ++i) {
            char c = cssContent.charAt(i);
            switch (c) {
                case '/': {
                    if (i < cssContent.length() - 1 && cssContent.charAt(i + 1) == '*') {
                        withinComment = true;
                        ++i;
                        continue block6;
                    }
                    if (i <= 0 || cssContent.charAt(i - 1) != '*') continue block6;
                    withinComment = false;
                    continue block6;
                }
                case '@': {
                    if (withinComment || !this.charsMatch$1(i, this.AtImportChars(), cssContent)) continue block6;
                    withinImport.elem = true;
                    i += "@import".length();
                    continue block6;
                }
                case 'u': {
                    if (withinComment || !withinImport.elem || !this.charsMatch$1(i, this.UrlStartChars(), cssContent)) continue block6;
                    urlStart = i += this.UrlStartChars().length;
                    withinUrl.elem = true;
                    continue block6;
                }
                case ')': {
                    if (withinComment || !withinUrl.elem) continue block6;
                    this.extractUrl(cssContent, urlStart, i).foreach((Function1)new CssParser$lambda$$extractResources$1(cssURI, resources2, withinImport, withinUrl));
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        return resources2.toList();
    }

    public final /* synthetic */ Option io$gatling$http$fetch$CssParser$$$anonfun$1(Regex.Match m) {
        String raw = m.group(1);
        return this.extractUrl(raw, 0, raw.length());
    }

    public static final /* synthetic */ Iterable io$gatling$http$fetch$CssParser$$$anonfun$2(Option xo) {
        return Option$.MODULE$.option2Iterable(xo);
    }

    private final int trimLeft$1(int cur, String string$1, int end$1, ObjectRef protectChar$1, BooleanRef broken$1) {
        int n;
        block5: while (true) {
            if (cur == end$1) {
                n = cur;
                break;
            }
            char c = string$1.charAt(cur);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': {
                    ++cur;
                    continue block5;
                }
                case '\'': {
                    int n2;
                    Option option = (Option)protectChar$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        protectChar$1.elem = this.SingleQuoteEscapeChar();
                        ++cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n2 = cur;
                    break block5;
                }
                case '\"': {
                    int n3;
                    Option option = (Option)protectChar$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        protectChar$1.elem = this.DoubleQuoteEscapeChar();
                        ++cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n3 = cur;
                    break block5;
                }
                default: {
                    n = cur;
                    break block5;
                }
            }
            break;
        }
        return n;
    }

    private final int trimRight$1(int cur, int leftLimit, String string$1, ObjectRef protectChar$1, BooleanRef broken$1) {
        int n;
        block5: while (true) {
            if (cur == leftLimit) {
                n = cur;
                break;
            }
            char c = string$1.charAt(cur - 1);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': {
                    --cur;
                    continue block5;
                }
                case '\'': {
                    int n2;
                    Option option = (Option)protectChar$1.elem;
                    Some<Object> some = this.SingleQuoteEscapeChar();
                    Option option2 = option;
                    if (!(some == null ? option2 != null : !some.equals((Object)option2))) {
                        --cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n2 = cur;
                    break block5;
                }
                case '\"': {
                    int n3;
                    Option option = (Option)protectChar$1.elem;
                    Some<Object> some = this.DoubleQuoteEscapeChar();
                    Option option3 = option;
                    if (!(some == null ? option3 != null : !some.equals((Object)option3))) {
                        --cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n3 = cur;
                    break block5;
                }
                default: {
                    n = cur;
                    break block5;
                }
            }
            break;
        }
        return n;
    }

    private final boolean charsMatchRec$1(int j, String cssContent$1, int i$1, char[] chars$1) {
        boolean bl;
        while (true) {
            if (j == chars$1.length) {
                bl = true;
                break;
            }
            if (cssContent$1.charAt(i$1 + j) != chars$1[j]) {
                bl = false;
                break;
            }
            ++j;
        }
        return bl;
    }

    private final boolean charsMatch$1(int i, char[] chars, String cssContent$1) {
        return i < cssContent$1.length() - chars.length && this.charsMatchRec$1(1, cssContent$1, i, chars);
    }

    public static final /* synthetic */ void io$gatling$http$fetch$CssParser$$$anonfun$4(ArrayBuffer resources$1, BooleanRef withinImport$1, BooleanRef withinUrl$1, Uri absoluteUri) {
        resources$1.$plus$eq((Object)new CssResource(absoluteUri));
        withinUrl$1.elem = false;
        withinImport$1.elem = false;
    }

    public static final /* synthetic */ void io$gatling$http$fetch$CssParser$$$anonfun$3(Uri cssURI$1, ArrayBuffer resources$1, BooleanRef withinImport$1, BooleanRef withinUrl$1, String url) {
        HttpHelper$.MODULE$.resolveFromUriSilently(cssURI$1, url).foreach((Function1)new CssParser$lambda$$io$gatling$http$fetch$CssParser$$$nestedInAnonfun$3$1(resources$1, withinImport$1, withinUrl$1));
    }

    private CssParser$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.InlineStyleImageUrls = new StringOps(Predef$.MODULE$.augmentString("url\\((.*)\\)")).r();
        this.StyleImportsUrls = new StringOps(Predef$.MODULE$.augmentString("@import url\\((.*)\\)")).r();
        this.SingleQuoteEscapeChar = new Some((Object)BoxesRunTime.boxToCharacter((char)'\''));
        this.DoubleQuoteEscapeChar = new Some((Object)BoxesRunTime.boxToCharacter((char)'\"'));
        this.AtImportChars = "@import".toCharArray();
        this.UrlStartChars = "url(".toCharArray();
    }
}

