/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.util.HttpHelper$lambda$$$nestedInAnonfun$4$1;
import io.gatling.http.util.HttpHelper$lambda$$$nestedInAnonfun$5$1;
import io.gatling.http.util.HttpHelper$lambda$$$nestedInAnonfun$6$1;
import io.gatling.http.util.HttpHelper$lambda$$buildRealm$1;
import io.gatling.http.util.HttpHelper$lambda$$extractCharsetFromContentType$1;
import io.gatling.http.util.HttpHelper$lambda$$io$gatling$http$util$HttpHelper$$$nestedInAnonfun$3$1;
import io.gatling.http.util.HttpHelper$lambda$$isAjax$1;
import io.gatling.http.util.HttpHelper$lambda$$isCss$1;
import io.gatling.http.util.HttpHelper$lambda$$isHtml$1;
import io.gatling.http.util.HttpHelper$lambda$$isTxt$1;
import io.gatling.http.util.HttpHelper$lambda$$parseFormBody$1;
import io.gatling.http.util.HttpHelper$lambda$$parseFormBody$2;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.Realm;
import org.asynchttpclient.uri.Uri;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class HttpHelper$
implements StrictLogging {
    public static final HttpHelper$ MODULE$;
    private final String HttpScheme;
    private final String WsScheme;
    private final Vector<Object> OkCodes;
    private final Vector<Object> RedirectStatusCodes;
    private final Logger logger;

    static {
        new HttpHelper$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String HttpScheme() {
        return this.HttpScheme;
    }

    public String WsScheme() {
        return this.WsScheme;
    }

    public Vector<Object> OkCodes() {
        return this.OkCodes;
    }

    public Vector<Object> RedirectStatusCodes() {
        return this.RedirectStatusCodes;
    }

    public List<Tuple2<String, String>> parseFormBody(String body2) {
        return (List)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])body2.split("&")).map((Function1)new HttpHelper$lambda$$parseFormBody$1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new HttpHelper$lambda$$parseFormBody$2(this), scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
    }

    public Function1<Session, Validation<Realm>> buildBasicAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return this.buildRealm(username, password, Realm.AuthScheme.BASIC, true, (Option<Function1<Session, Validation<String>>>)None$.MODULE$, (Option<Function1<Session, Validation<String>>>)None$.MODULE$);
    }

    public Function1<Session, Validation<Realm>> buildDigestAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return this.buildRealm(username, password, Realm.AuthScheme.DIGEST, false, (Option<Function1<Session, Validation<String>>>)None$.MODULE$, (Option<Function1<Session, Validation<String>>>)None$.MODULE$);
    }

    public Function1<Session, Validation<Realm>> buildNTLMAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password, Function1<Session, Validation<String>> ntlmDomain, Function1<Session, Validation<String>> ntlmHost) {
        return this.buildRealm(username, password, Realm.AuthScheme.NTLM, false, (Option<Function1<Session, Validation<String>>>)new Some(ntlmDomain), (Option<Function1<Session, Validation<String>>>)new Some(ntlmHost));
    }

    public Function1<Session, Validation<Realm>> buildRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password, Realm.AuthScheme authScheme, boolean preemptive, Option<Function1<Session, Validation<String>>> ntlmDomain, Option<Function1<Session, Validation<String>>> ntlmHost) {
        return (Function1)new HttpHelper$lambda$$buildRealm$1(username, password, authScheme, preemptive, ntlmDomain, ntlmHost);
    }

    private boolean headerExists(HttpHeaders headers2, String headerName, Function1<String, Object> f) {
        return Option$.MODULE$.apply((Object)headers2.get(headerName)).exists(f);
    }

    public boolean isCss(HttpHeaders headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)((Function1)new HttpHelper$lambda$$isCss$1()));
    }

    public boolean isHtml(HttpHeaders headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)((Function1)new HttpHelper$lambda$$isHtml$1()));
    }

    public boolean isAjax(HttpHeaders headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.XRequestedWith(), (Function1<String, Object>)((Function1)new HttpHelper$lambda$$isAjax$1()));
    }

    public boolean isTxt(HttpHeaders headers2) {
        return this.headerExists(headers2, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)((Function1)new HttpHelper$lambda$$isTxt$1()));
    }

    public Uri resolveFromUri(Uri rootURI2, String relative) {
        return relative.startsWith("//") ? Uri.create((String)new StringBuilder().append((Object)rootURI2.getScheme()).append((Object)":").append((Object)relative).toString()) : Uri.create((Uri)rootURI2, (String)relative);
    }

    public Option<Uri> resolveFromUriSilently(Uri rootURI2, String relative) {
        Some some;
        try {
            some = new Some((Object)this.resolveFromUri(rootURI2, relative));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to resolve URI rootURI='", "', relative='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootURI2, relative})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public boolean isRedirect(int statusCode) {
        return this.RedirectStatusCodes().contains((Object)BoxesRunTime.boxToInteger((int)statusCode));
    }

    public boolean isPermanentRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 308;
    }

    public boolean isNotModified(int statusCode) {
        return statusCode == 304;
    }

    public boolean isAbsoluteHttpUrl(String url) {
        return url.startsWith(this.HttpScheme());
    }

    public boolean isAbsoluteWsUrl(String url) {
        return url.startsWith(this.WsScheme());
    }

    public Option<Charset> extractCharsetFromContentType(String contentType2) {
        None$ none$;
        int n = contentType2.indexOf("charset=");
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                int n2;
                IntRef start2 = IntRef.create((int)(n + "charset=".length()));
                if (contentType2.regionMatches(true, start2.elem, "UTF-8", 0, 5)) {
                    none$ = new Some((Object)StandardCharsets.UTF_8);
                    break;
                }
                int n3 = contentType2.indexOf(59, start2.elem);
                switch (n3) {
                    case -1: {
                        n2 = contentType2.length();
                        break;
                    }
                    default: {
                        n2 = n3;
                        break;
                    }
                }
                IntRef end = IntRef.create((int)n2);
                none$ = Try$.MODULE$.apply((Function0)new HttpHelper$lambda$$extractCharsetFromContentType$1(contentType2, start2, end)).toOption();
                break;
            }
        }
        return none$;
    }

    private final String utf8Decode$1(String s) {
        return URLDecoder.decode(s, Codec$.MODULE$.UTF8().name());
    }

    public static final /* synthetic */ String[] io$gatling$http$util$HttpHelper$$$anonfun$1(String x$1) {
        return x$1.split("=", 2);
    }

    public final /* synthetic */ Tuple2 io$gatling$http$util$HttpHelper$$$anonfun$2(String[] pair) {
        String paramName = this.utf8Decode$1(pair[0]);
        String paramValue = pair.length > 1 ? this.utf8Decode$1(pair[1]) : "";
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)paramName), (Object)paramValue);
    }

    public static final /* synthetic */ Realm io$gatling$http$util$HttpHelper$$$anonfun$7(Realm.AuthScheme authScheme$1, boolean preemptive$1, String usernameValue$1, String passwordValue$1, Option ntlmDomainValue$1, Option ntlmHostValue) {
        return new Realm.Builder(usernameValue$1, passwordValue$1).setScheme(authScheme$1).setUsePreemptiveAuth(preemptive$1).setNtlmDomain((String)ntlmDomainValue$1.orNull(Predef$.MODULE$.$conforms())).setNtlmHost((String)ntlmHostValue.orNull(Predef$.MODULE$.$conforms())).build();
    }

    public static final /* synthetic */ Validation io$gatling$http$util$HttpHelper$$$anonfun$6(Realm.AuthScheme authScheme$1, boolean preemptive$1, Option ntlmHost$1, Session session$1, String usernameValue$1, String passwordValue$1, Option ntlmDomainValue) {
        return io.gatling.core.session.package$.MODULE$.resolveOptionalExpression(ntlmHost$1, session$1).map((Function1)new HttpHelper$lambda$$$nestedInAnonfun$6$1(authScheme$1, preemptive$1, usernameValue$1, passwordValue$1, ntlmDomainValue));
    }

    public static final /* synthetic */ Validation io$gatling$http$util$HttpHelper$$$anonfun$5(Realm.AuthScheme authScheme$1, boolean preemptive$1, Option ntlmDomain$1, Option ntlmHost$1, Session session$1, String usernameValue$1, String passwordValue) {
        return io.gatling.core.session.package$.MODULE$.resolveOptionalExpression(ntlmDomain$1, session$1).flatMap((Function1)new HttpHelper$lambda$$$nestedInAnonfun$5$1(authScheme$1, preemptive$1, ntlmHost$1, session$1, usernameValue$1, passwordValue));
    }

    public static final /* synthetic */ Validation io$gatling$http$util$HttpHelper$$$anonfun$4(Function1 password$1, Realm.AuthScheme authScheme$1, boolean preemptive$1, Option ntlmDomain$1, Option ntlmHost$1, Session session$1, String usernameValue) {
        return ((Validation)password$1.apply((Object)session$1)).flatMap((Function1)new HttpHelper$lambda$$$nestedInAnonfun$4$1(authScheme$1, preemptive$1, ntlmDomain$1, ntlmHost$1, session$1, usernameValue));
    }

    public static final /* synthetic */ Validation io$gatling$http$util$HttpHelper$$$anonfun$3(Function1 username$1, Function1 password$1, Realm.AuthScheme authScheme$1, boolean preemptive$1, Option ntlmDomain$1, Option ntlmHost$1, Session session) {
        return ((Validation)username$1.apply((Object)session)).flatMap((Function1)new HttpHelper$lambda$$io$gatling$http$util$HttpHelper$$$nestedInAnonfun$3$1(password$1, authScheme$1, preemptive$1, ntlmDomain$1, ntlmHost$1, session));
    }

    public static final /* synthetic */ boolean io$gatling$http$util$HttpHelper$$$anonfun$8(String x$2) {
        return x$2.contains(HeaderValues$.MODULE$.TextCss());
    }

    public static final /* synthetic */ boolean io$gatling$http$util$HttpHelper$$$anonfun$9(String ct) {
        return ct.contains(HeaderValues$.MODULE$.TextHtml()) || ct.contains(HeaderValues$.MODULE$.ApplicationXhtml());
    }

    public static final /* synthetic */ boolean io$gatling$http$util$HttpHelper$$$anonfun$10(String x$3) {
        return x$3.contains(HeaderValues$.MODULE$.XmlHttpRequest());
    }

    public static final /* synthetic */ boolean io$gatling$http$util$HttpHelper$$$anonfun$11(String ct) {
        return ct.contains("text") || ct.contains("json") || ct.contains("javascript") || ct.contains("xml");
    }

    public static final /* synthetic */ Charset io$gatling$http$util$HttpHelper$$$anonfun$12(String contentType$1, IntRef start$1, IntRef end$1) {
        while (contentType$1.charAt(start$1.elem) == ' ' && start$1.elem < end$1.elem) {
            ++start$1.elem;
        }
        while (contentType$1.charAt(end$1.elem - 1) == ' ' && end$1.elem > start$1.elem) {
            --end$1.elem;
        }
        if (contentType$1.charAt(start$1.elem) == '\"' && start$1.elem < end$1.elem) {
            ++start$1.elem;
        }
        if (contentType$1.charAt(end$1.elem - 1) == '\"' && end$1.elem > start$1.elem) {
            --end$1.elem;
        }
        String charsetString = contentType$1.substring(start$1.elem, end$1.elem);
        return Charset.forName(charsetString);
    }

    private HttpHelper$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.HttpScheme = "http";
        this.WsScheme = "ws";
        this.OkCodes = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{200, 304, 201, 202, 203, 204, 205, 206, 207, 208, 209}));
        this.RedirectStatusCodes = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{301, 302, 303, 307, 308}));
    }
}

