/*
 * Decompiled with CFR 0.152.
 */
package io.github.benas.randombeans.api;

import io.github.benas.randombeans.util.Constants;
import io.github.benas.randombeans.util.Range;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Random;

public class EnhancedRandomParameters {
    private long seed = new Random().nextLong();
    private int objectPoolSize = 10;
    private int randomizationDepth;
    private Charset charset = StandardCharsets.US_ASCII;
    private boolean scanClasspathForConcreteTypes = false;
    private boolean overrideDefaultInitialization = false;
    private Range<Integer> collectionSizeRange;
    private Range<Integer> stringLengthRange;
    private Range<LocalDate> dateRange;
    private Range<LocalTime> timeRange;

    public EnhancedRandomParameters() {
        this.randomizationDepth = Integer.MAX_VALUE;
        this.dateRange = new Range<LocalDate>(Constants.DEFAULT_DATES_RANGE.getMin().toLocalDate(), Constants.DEFAULT_DATES_RANGE.getMax().toLocalDate());
        this.timeRange = new Range<LocalTime>(LocalTime.MIN, LocalTime.MAX);
        this.collectionSizeRange = Constants.DEFAULT_COLLECTION_SIZE_RANGE;
        this.stringLengthRange = Constants.DEFAULT_STRING_LENGTH_RANGE;
    }

    public void setCollectionSizeRange(Range<Integer> collectionSizeRange) {
        this.collectionSizeRange = collectionSizeRange;
    }

    public void setDateRange(Range<LocalDate> dateRange) {
        this.dateRange = dateRange;
    }

    public void setTimeRange(Range<LocalTime> timeRange) {
        this.timeRange = timeRange;
    }

    public void setStringLengthRange(Range<Integer> stringLengthRange) {
        this.stringLengthRange = stringLengthRange;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getObjectPoolSize() {
        return this.objectPoolSize;
    }

    public int getRandomizationDepth() {
        return this.randomizationDepth;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isScanClasspathForConcreteTypes() {
        return this.scanClasspathForConcreteTypes;
    }

    public boolean isOverrideDefaultInitialization() {
        return this.overrideDefaultInitialization;
    }

    public Range<Integer> getCollectionSizeRange() {
        return this.collectionSizeRange;
    }

    public Range<Integer> getStringLengthRange() {
        return this.stringLengthRange;
    }

    public Range<LocalDate> getDateRange() {
        return this.dateRange;
    }

    public Range<LocalTime> getTimeRange() {
        return this.timeRange;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setObjectPoolSize(int objectPoolSize) {
        this.objectPoolSize = objectPoolSize;
    }

    public void setRandomizationDepth(int randomizationDepth) {
        this.randomizationDepth = randomizationDepth;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setScanClasspathForConcreteTypes(boolean scanClasspathForConcreteTypes) {
        this.scanClasspathForConcreteTypes = scanClasspathForConcreteTypes;
    }

    public void setOverrideDefaultInitialization(boolean overrideDefaultInitialization) {
        this.overrideDefaultInitialization = overrideDefaultInitialization;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnhancedRandomParameters)) {
            return false;
        }
        EnhancedRandomParameters other = (EnhancedRandomParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getObjectPoolSize() != other.getObjectPoolSize()) {
            return false;
        }
        if (this.getRandomizationDepth() != other.getRandomizationDepth()) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        if (this.isScanClasspathForConcreteTypes() != other.isScanClasspathForConcreteTypes()) {
            return false;
        }
        if (this.isOverrideDefaultInitialization() != other.isOverrideDefaultInitialization()) {
            return false;
        }
        Range<Integer> this$collectionSizeRange = this.getCollectionSizeRange();
        Range<Integer> other$collectionSizeRange = other.getCollectionSizeRange();
        if (this$collectionSizeRange == null ? other$collectionSizeRange != null : !((Object)this$collectionSizeRange).equals(other$collectionSizeRange)) {
            return false;
        }
        Range<Integer> this$stringLengthRange = this.getStringLengthRange();
        Range<Integer> other$stringLengthRange = other.getStringLengthRange();
        if (this$stringLengthRange == null ? other$stringLengthRange != null : !((Object)this$stringLengthRange).equals(other$stringLengthRange)) {
            return false;
        }
        Range<LocalDate> this$dateRange = this.getDateRange();
        Range<LocalDate> other$dateRange = other.getDateRange();
        if (this$dateRange == null ? other$dateRange != null : !((Object)this$dateRange).equals(other$dateRange)) {
            return false;
        }
        Range<LocalTime> this$timeRange = this.getTimeRange();
        Range<LocalTime> other$timeRange = other.getTimeRange();
        return !(this$timeRange == null ? other$timeRange != null : !((Object)this$timeRange).equals(other$timeRange));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EnhancedRandomParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getObjectPoolSize();
        result = result * 59 + this.getRandomizationDepth();
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        result = result * 59 + (this.isScanClasspathForConcreteTypes() ? 79 : 97);
        result = result * 59 + (this.isOverrideDefaultInitialization() ? 79 : 97);
        Range<Integer> $collectionSizeRange = this.getCollectionSizeRange();
        result = result * 59 + ($collectionSizeRange == null ? 43 : ((Object)$collectionSizeRange).hashCode());
        Range<Integer> $stringLengthRange = this.getStringLengthRange();
        result = result * 59 + ($stringLengthRange == null ? 43 : ((Object)$stringLengthRange).hashCode());
        Range<LocalDate> $dateRange = this.getDateRange();
        result = result * 59 + ($dateRange == null ? 43 : ((Object)$dateRange).hashCode());
        Range<LocalTime> $timeRange = this.getTimeRange();
        result = result * 59 + ($timeRange == null ? 43 : ((Object)$timeRange).hashCode());
        return result;
    }

    public String toString() {
        return "EnhancedRandomParameters(seed=" + this.getSeed() + ", objectPoolSize=" + this.getObjectPoolSize() + ", randomizationDepth=" + this.getRandomizationDepth() + ", charset=" + this.getCharset() + ", scanClasspathForConcreteTypes=" + this.isScanClasspathForConcreteTypes() + ", overrideDefaultInitialization=" + this.isOverrideDefaultInitialization() + ", collectionSizeRange=" + this.getCollectionSizeRange() + ", stringLengthRange=" + this.getStringLengthRange() + ", dateRange=" + this.getDateRange() + ", timeRange=" + this.getTimeRange() + ")";
    }
}

