/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class BallRotateIndicator
extends Indicator {
    float scaleFloat = 0.5f;
    float degress;
    private Matrix mMatrix = new Matrix();

    @Override
    public void draw(Canvas canvas, Paint paint) {
        float radius = this.getWidth() / 10;
        float x = this.getWidth() / 2;
        float y = this.getHeight() / 2;
        canvas.rotate(this.degress, (float)this.centerX(), (float)this.centerY());
        canvas.save();
        canvas.translate(x - radius * 2.0f - radius, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.drawCircle(0.0f, 0.0f, radius, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(x, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.drawCircle(0.0f, 0.0f, radius, paint);
        canvas.restore();
        canvas.save();
        canvas.translate(x + radius * 2.0f + radius, y);
        canvas.scale(this.scaleFloat, this.scaleFloat);
        canvas.drawCircle(0.0f, 0.0f, radius, paint);
        canvas.restore();
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        ValueAnimator scaleAnim = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f, 0.5f});
        scaleAnim.setDuration(1000L);
        scaleAnim.setRepeatCount(-1);
        this.addUpdateListener(scaleAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallRotateIndicator.this.scaleFloat = ((Float)animation.getAnimatedValue()).floatValue();
                BallRotateIndicator.this.postInvalidate();
            }
        });
        ValueAnimator rotateAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 180.0f, 360.0f});
        this.addUpdateListener(rotateAnim, new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BallRotateIndicator.this.degress = ((Float)animation.getAnimatedValue()).floatValue();
                BallRotateIndicator.this.postInvalidate();
            }
        });
        rotateAnim.setDuration(1000L);
        rotateAnim.setRepeatCount(-1);
        animators.add(scaleAnim);
        animators.add(rotateAnim);
        return animators;
    }
}

