/*
 * Decompiled with CFR 0.152.
 */
package feign.form.spring;

import feign.codec.EncodeException;
import feign.form.multipart.AbstractWriter;
import feign.form.multipart.Output;
import feign.form.spring.SpringSingleMultipartFileWriter;
import java.util.Iterator;
import org.springframework.web.multipart.MultipartFile;

public class SpringManyMultipartFilesWriter
extends AbstractWriter {
    private final SpringSingleMultipartFileWriter fileWriter = new SpringSingleMultipartFileWriter();

    public boolean isApplicable(Object value) {
        if (value instanceof MultipartFile[]) {
            return true;
        }
        if (!(value instanceof Iterable)) {
            return false;
        }
        Iterable iterable = (Iterable)value;
        Iterator iterator = iterable.iterator();
        return iterator.hasNext() && iterator.next() instanceof MultipartFile;
    }

    public void write(Output output, String boundary, String key, Object value) throws EncodeException {
        if (value instanceof MultipartFile[]) {
            MultipartFile[] files;
            for (MultipartFile file : files = (MultipartFile[])value) {
                this.fileWriter.write(output, boundary, key, file);
            }
        } else if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            for (Object file : iterable) {
                this.fileWriter.write(output, boundary, key, file);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }
}

