/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.addon.spreadsheet.Spreadsheet;
import com.vaadin.navigator.View;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import io.graphenee.core.callback.TRParamCallback;
import io.graphenee.core.model.bean.GxSavedQueryBean;
import io.graphenee.core.util.JSONUtils;
import io.graphenee.core.vaadin.GxSaveQueryForm;
import io.graphenee.vaadin.AbstractDashboardPanel;
import io.graphenee.vaadin.TRAbstractBaseForm;
import io.graphenee.vaadin.TRAbstractQueryForm;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.vaadin.viritin.button.DownloadButton;
import org.vaadin.viritin.layouts.MVerticalLayout;

public abstract class GxAbstractQuerySpreadsheetPanel<QB, RB>
extends AbstractDashboardPanel
implements View,
TRAbstractQueryForm.QueryFormDelegate<QB> {
    private static final long serialVersionUID = 1L;
    private static final Logger L = LoggerFactory.getLogger(GxAbstractQuerySpreadsheetPanel.class);
    private Class<QB> queryBeanClass;
    private TabSheet tabsheet;
    private CellStyle dateStyle;
    private CellStyle dateTimeStyle;
    private CellStyle timeStyle;
    private TRParamCallback<GxSavedQueryBean> onSaveCallback;
    private TRParamCallback<GxSavedQueryBean> onDeleteCallback;

    public GxAbstractQuerySpreadsheetPanel(Class<QB> queryBeanClass) {
        this.queryBeanClass = queryBeanClass;
    }

    public void onSubmit(final QB queryBean) {
        final Spreadsheet spreadsheet = new Spreadsheet();
        spreadsheet.setReadOnly(true);
        final Workbook workbook = spreadsheet.getWorkbook();
        final Sheet sheet = workbook.getSheetAt(0);
        this.dateStyle = sheet.getWorkbook().createCellStyle();
        this.dateStyle.setDataFormat(sheet.getWorkbook().createDataFormat().getFormat("dd/MM/yyyy"));
        this.dateTimeStyle = sheet.getWorkbook().createCellStyle();
        this.dateTimeStyle.setDataFormat(sheet.getWorkbook().createDataFormat().getFormat("dd/MM/yyyy hh:mm"));
        this.timeStyle = sheet.getWorkbook().createCellStyle();
        this.timeStyle.setDataFormat(sheet.getWorkbook().createDataFormat().getFormat("hh:mm"));
        final DownloadButton downloadButton = new DownloadButton();
        downloadButton.setIcon((Resource)FontAwesome.FILE_EXCEL_O);
        downloadButton.setCaption("Download");
        String file = "results.xls";
        if (workbook instanceof XSSFWorkbook) {
            file = file + "x";
        }
        downloadButton.setFileName(file);
        downloadButton.setWriter(new DownloadButton.ContentWriter(){

            public void write(OutputStream stream) {
                try {
                    workbook.write(stream);
                }
                catch (IOException e) {
                    L.warn(e.getMessage(), (Throwable)e);
                }
            }
        });
        downloadButton.setVisible(false);
        spreadsheet.setVisible(false);
        final ProgressBar progress = new ProgressBar();
        progress.setCaption("Preparing results, please wait...");
        progress.setIndeterminate(true);
        TabSheet.Tab tab = this.tabsheet.addTab((Component)new MVerticalLayout(new Component[]{progress, downloadButton, spreadsheet}).withExpand((Component)spreadsheet, 1.0f).withFullHeight());
        tab.setCaption("Results");
        tab.setClosable(true);
        this.tabsheet.setSelectedTab(tab);
        SimpleAsyncTaskExecutor executor = new SimpleAsyncTaskExecutor();
        ListenableFuture listenable = executor.submitListenable(new Callable<Collection<RB>>(){

            @Override
            public Collection<RB> call() throws Exception {
                Collection query = GxAbstractQuerySpreadsheetPanel.this.query(queryBean);
                return query;
            }
        });
        listenable.addCallback(new ListenableFutureCallback<Collection<RB>>(){

            public void onSuccess(Collection<RB> result) {
                UI.getCurrent().access(() -> {
                    Iterator iter = result.iterator();
                    Row headerRow = sheet.createRow(0);
                    GxAbstractQuerySpreadsheetPanel.this.generateCellsForHeaderRow(sheet, headerRow);
                    int i = 1;
                    while (iter.hasNext()) {
                        Object bean = iter.next();
                        Row row = sheet.createRow(i);
                        try {
                            GxAbstractQuerySpreadsheetPanel.this.generateCellsForDataRow(sheet, row, bean);
                        }
                        catch (Exception e) {
                            L.error(e.getMessage(), (Throwable)e);
                        }
                        ++i;
                    }
                    for (int k = headerRow.getFirstCellNum(); k <= headerRow.getLastCellNum(); ++k) {
                        spreadsheet.autofitColumn(k);
                    }
                    downloadButton.setVisible(true);
                    spreadsheet.setVisible(true);
                    progress.setVisible(false);
                    UI.getCurrent().push();
                });
            }

            public void onFailure(Throwable ex) {
                ex.printStackTrace();
            }
        });
    }

    protected boolean shouldShowHeader() {
        return true;
    }

    protected abstract void generateCellsForDataRow(Sheet var1, Row var2, RB var3);

    protected abstract void generateCellsForHeaderRow(Sheet var1, Row var2);

    protected abstract Collection<RB> query(QB var1);

    protected void postInitialize() {
        try {
            QB queryBean = this.queryBeanClass.newInstance();
            this.queryForm().setEntity(queryBean);
            this.queryForm().setQueryFormDelegate((TRAbstractQueryForm.QueryFormDelegate)this);
            this.queryForm().addButtonToFooter("Save", bean -> this.saveQuery(bean));
            this.tabsheet = new TabSheet();
            this.tabsheet.setSizeFull();
            this.tabsheet.setStyleName("framed");
            this.queryForm().setCaption("Query");
            this.tabsheet.addComponents(new Component[]{this.queryForm()});
            this.addComponent((Component)this.tabsheet);
        }
        catch (IllegalAccessException | InstantiationException e) {
            L.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void saveQuery(QB bean) {
        final GxSaveQueryForm saveQueryForm = new GxSaveQueryForm();
        GxSavedQueryBean savedQueryBean = new GxSavedQueryBean();
        String json = JSONUtils.objectToJson(bean);
        savedQueryBean.setQueryBeanJson(json);
        saveQueryForm.setEntity(savedQueryBean);
        saveQueryForm.openInModalPopup();
        saveQueryForm.setSavedHandler((TRAbstractBaseForm.SavedHandler)new TRAbstractBaseForm.SavedHandler<GxSavedQueryBean>(){

            public void onSave(GxSavedQueryBean entity) {
                saveQueryForm.closePopup();
                if (GxAbstractQuerySpreadsheetPanel.this.onSaveCallback != null) {
                    GxAbstractQuerySpreadsheetPanel.this.onSaveCallback.execute((Object)entity);
                }
            }
        });
    }

    public abstract TRAbstractQueryForm<QB> queryForm();

    protected CellStyle getDateStyle() {
        return this.dateStyle;
    }

    protected CellStyle getDateTimeStyle() {
        return this.dateTimeStyle;
    }

    protected CellStyle getTimeStyle() {
        return this.timeStyle;
    }

    public void setOnSaveCallback(TRParamCallback<GxSavedQueryBean> onSaveCallback) {
        this.onSaveCallback = onSaveCallback;
    }

    public void setOnDeleteCallback(TRParamCallback<GxSavedQueryBean> onDeleteCallback) {
        this.onDeleteCallback = onDeleteCallback;
    }
}

