/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.fieldgroup.PropertyId;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import io.graphenee.core.model.BeanFault;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxCityBean;
import io.graphenee.vaadin.BeanFaultContainer;
import io.graphenee.vaadin.TRAbstractForm;
import io.graphenee.vaadin.component.BeanFaultComboBox;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.vaadin.viritin.fields.MCheckBox;
import org.vaadin.viritin.fields.MTextField;

@SpringComponent
@Scope(value="prototype")
public class GxCityForm
extends TRAbstractForm<GxCityBean> {
    @Autowired
    GxDataService gxDataService;
    @PropertyId(value="cityName")
    MTextField cityName;
    @PropertyId(value="cityCode")
    MTextField cityCode;
    @PropertyId(value="isActive")
    MCheckBox isActive;
    @PropertyId(value="countryBeanFault")
    BeanFaultComboBox countryBeanFaultComboBox;
    @PropertyId(value="stateBeanFault")
    BeanFaultComboBox stateBeanFaultComboBox;

    protected void addFieldsToForm(FormLayout form) {
        this.cityName = new MTextField("City Name").withRequired(true);
        this.isActive = new MCheckBox("Is Active?");
        this.countryBeanFaultComboBox = new BeanFaultComboBox("Country");
        this.countryBeanFaultComboBox.setRequired(true);
        BeanFaultContainer countryBeanFaultContainer = new BeanFaultContainer("oid");
        countryBeanFaultContainer.setBeans((Collection)this.gxDataService.findCountry());
        this.countryBeanFaultComboBox.setContainerDataSource((Container)countryBeanFaultContainer);
        this.countryBeanFaultComboBox.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.countryBeanFaultComboBox.setItemCaptionPropertyId((Object)"countryName");
        this.stateBeanFaultComboBox = new BeanFaultComboBox("State");
        BeanFaultContainer stateBeanFaultContainer = new BeanFaultContainer("oid");
        stateBeanFaultContainer.setBeans((Collection)this.gxDataService.findState());
        this.stateBeanFaultComboBox.setContainerDataSource((Container)stateBeanFaultContainer);
        this.stateBeanFaultComboBox.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.stateBeanFaultComboBox.setItemCaptionPropertyId((Object)"stateName");
        this.countryBeanFaultComboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            BeanFault selectedCountry = (BeanFault)this.countryBeanFaultComboBox.getValue();
            this.stateBeanFaultComboBox.setValue(null);
            stateBeanFaultContainer.removeAllItems();
            if (selectedCountry != null) {
                stateBeanFaultContainer.setBeans((Collection)this.gxDataService.findStateByCountry((Integer)selectedCountry.getOid()));
            } else {
                stateBeanFaultContainer.setBeans((Collection)this.gxDataService.findState());
            }
        });
        form.addComponents(new Component[]{this.cityName, this.countryBeanFaultComboBox, this.stateBeanFaultComboBox, this.isActive});
    }

    protected boolean eagerValidationEnabled() {
        return true;
    }

    protected String formTitle() {
        return "City";
    }

    protected String popupHeight() {
        return "250px";
    }

    protected String popupWidth() {
        return "450px";
    }
}

