/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.spring.annotation.SpringComponent;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxCityBean;
import io.graphenee.core.vaadin.GxCityForm;
import io.graphenee.vaadin.AbstractEntityListPanel;
import io.graphenee.vaadin.TRAbstractForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@SpringComponent
@Scope(value="prototype")
public class GxCityListPanel
extends AbstractEntityListPanel<GxCityBean> {
    @Autowired
    GxDataService dataService;
    @Autowired
    GxCityForm editorForm;

    public GxCityListPanel() {
        super(GxCityBean.class);
    }

    protected boolean onSaveEntity(GxCityBean entity) {
        this.dataService.createOrUpdate(entity);
        return true;
    }

    protected boolean onDeleteEntity(GxCityBean entity) {
        this.dataService.delete(entity);
        return true;
    }

    protected String panelCaption() {
        return "Countries";
    }

    protected List<GxCityBean> fetchEntities() {
        return this.dataService.findCity();
    }

    protected String[] visibleProperties() {
        return new String[]{"cityName", "countryName", "stateName", "isActive"};
    }

    protected TRAbstractForm<GxCityBean> editorForm() {
        return this.editorForm;
    }

    protected boolean isGridCellFilterEnabled() {
        return true;
    }
}

