/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.spring.annotation.SpringComponent;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxCountryBean;
import io.graphenee.core.vaadin.GxCountryForm;
import io.graphenee.vaadin.AbstractEntityListPanel;
import io.graphenee.vaadin.TRAbstractForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@SpringComponent
@Scope(value="prototype")
public class GxCountryListPanel
extends AbstractEntityListPanel<GxCountryBean> {
    @Autowired
    GxDataService dataService;
    @Autowired
    GxCountryForm editorForm;

    public GxCountryListPanel() {
        super(GxCountryBean.class);
    }

    protected boolean onSaveEntity(GxCountryBean entity) {
        this.dataService.createOrUpdate(entity);
        return true;
    }

    protected boolean onDeleteEntity(GxCountryBean entity) {
        this.dataService.delete(entity);
        return true;
    }

    protected String panelCaption() {
        return "Countries";
    }

    protected List<GxCountryBean> fetchEntities() {
        return this.dataService.findCountry();
    }

    protected String[] visibleProperties() {
        return new String[]{"countryName", "alpha3Code", "numericCode"};
    }

    protected TRAbstractForm<GxCountryBean> editorForm() {
        return this.editorForm;
    }

    protected boolean isGridCellFilterEnabled() {
        return true;
    }
}

