/*
 * Decompiled with CFR 0.152.
 */
package io.graphenee.core.vaadin;

import com.vaadin.event.FieldEvents;
import com.vaadin.spring.annotation.SpringComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.VerticalLayout;
import io.graphenee.core.model.api.GxDataService;
import io.graphenee.core.model.bean.GxEmailTemplateBean;
import io.graphenee.vaadin.TRAbstractForm;
import io.graphenee.vaadin.component.BeanFaultComboBox;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.vaadin.viritin.fields.MCheckBox;
import org.vaadin.viritin.fields.MTextArea;
import org.vaadin.viritin.fields.MTextField;
import org.vaadin.viritin.label.MLabel;
import org.vaadin.viritin.layouts.MFormLayout;
import org.vaadin.viritin.layouts.MVerticalLayout;

@SpringComponent
@Scope(value="prototype")
public class GxEmailTemplateForm
extends TRAbstractForm<GxEmailTemplateBean> {
    @Autowired
    GxDataService gxDataService;
    BeanFaultComboBox namespaceBeanFault;
    MTextField templateName;
    MTextField templateCode;
    MTextField subject;
    MTextArea body;
    MTextArea smsBody;
    MTextArea ccList;
    MTextArea bccList;
    MTextField senderEmailAddress;
    MLabel msg;
    MCheckBox isActive;
    protected VerticalLayout detailsTab;
    protected TabSheet mainTabSheet;
    final int perSMSMaxLength = 160;

    protected void postBinding(GxEmailTemplateBean entity) {
        this.mainTabSheet.setSelectedTab(0);
    }

    protected Component getFormComponent() {
        this.detailsTab = new MVerticalLayout().withSpacing(false);
        this.detailsTab.setSizeFull();
        this.detailsTab.addComponent((Component)this.constructTemplateInfoForm());
        this.mainTabSheet = new TabSheet();
        this.mainTabSheet.setSizeFull();
        this.mainTabSheet.setStyleName("framed");
        this.mainTabSheet.addComponent((Component)this.emailTab());
        this.mainTabSheet.addComponent((Component)this.smsTab());
        this.detailsTab.addComponent((Component)this.mainTabSheet);
        this.detailsTab.setExpandRatio((Component)this.mainTabSheet, 1.0f);
        return this.detailsTab;
    }

    private FormLayout constructTemplateInfoForm() {
        MFormLayout templateInfoForm = new MFormLayout().withStyleName(new String[]{"light"}).withMargin(false);
        this.templateName = new MTextField("Name").withRequired(true);
        this.templateName.setMaxLength(50);
        this.templateName.setNullRepresentation(null);
        this.templateCode = new MTextField("Code").withRequired(true);
        this.templateCode.setMaxLength(100);
        this.templateCode.setNullRepresentation(null);
        this.isActive = new MCheckBox("Is Active?");
        templateInfoForm.addComponents(new Component[]{this.templateName, this.templateCode, this.isActive});
        return templateInfoForm;
    }

    private FormLayout emailTab() {
        MFormLayout emailForm = new MFormLayout().withStyleName(new String[]{"light"});
        emailForm.setSizeFull();
        emailForm.setCaption("Email Message");
        this.subject = new MTextField("Subject").withRequired(true);
        this.subject.setMaxLength(500);
        this.body = new MTextArea("Body").withRequired(true);
        this.body.setInputPrompt("Dear #{lastName}, \nThis is a test message.");
        this.body.setRows(10);
        this.ccList = new MTextArea("CC To").withRequired(false);
        this.ccList.setInputPrompt("Separate email addresses with , or ;");
        this.ccList.setRows(2);
        this.ccList.setMaxLength(500);
        this.bccList = new MTextArea("BCC To").withRequired(false);
        this.bccList.setInputPrompt("Separate email addresses with , or ;");
        this.bccList.setRows(2);
        this.bccList.setMaxLength(500);
        this.senderEmailAddress = new MTextField("Sender");
        this.senderEmailAddress.setMaxLength(200);
        emailForm.addComponents(new Component[]{this.subject, this.body, this.ccList, this.bccList, this.senderEmailAddress});
        return emailForm;
    }

    private FormLayout smsTab() {
        MFormLayout smsForm = new MFormLayout().withStyleName(new String[]{"light"});
        smsForm.setSizeFull();
        smsForm.setCaption("SMS Message");
        this.smsBody = new MTextArea("Body").withRequired(true);
        this.smsBody.setInputPrompt("Dear #{lastName}, \nThis is a test message.");
        this.smsBody.setRows(15);
        this.msg = new MLabel();
        this.smsBody.addTextChangeListener((FieldEvents.TextChangeListener & Serializable)event -> {
            Integer result = event.getText().length() / 160;
            if (event.getText().length() > 160) {
                if (event.getText().length() % 160 == 0) {
                    this.msg.setValue("The message will consume " + result + " no. of sms.");
                } else {
                    this.msg.setValue("The message will consume " + (result + 1) + " no. of sms.");
                }
            } else {
                this.msg.setValue(null);
            }
        });
        smsForm.addComponents(new Component[]{this.smsBody, this.msg});
        return smsForm;
    }

    protected boolean eagerValidationEnabled() {
        return true;
    }

    protected String formTitle() {
        return "Message Template";
    }

    protected String popupHeight() {
        return "550px";
    }
}

